<?php
header('Content-Type: application/json');

function getiv($str) {
    $offset = strlen($str) - 16;
    return substr($str, $offset >> 1, 16);
}

function decrypt($encrypted_config) {
    $iv = getiv($encrypted_config);
    $decoded = base64_decode(str_replace($iv, "", $encrypted_config));
    return openssl_decrypt($decoded, 'AES-128-CBC', "5003074310b30090", OPENSSL_RAW_DATA, $iv);
}

function cacheData($cacheFile, $data) {
    file_put_contents($cacheFile, json_encode($data));
}

function getCache($cacheFile) {
    if (file_exists($cacheFile) && time() - filemtime($cacheFile) < 3600) {
        return json_decode(file_get_contents($cacheFile), true);
    }
    return null;
}

$cacheFile = __DIR__ . '/vpn_cache.json';
$cachedData = getCache($cacheFile);

if (!$cachedData) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://migmigo-api.seventwo4.com/millions/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'package=fast.lucky.usa.freevpn&device_id=759F97017F984566870A639C9674B5C91714300347839&os=Android_11+%2830%29&display=RP1A.200720.012.A507FNXXS7DWD1+%281080x2257%29&version_code=6&locale=fa&gdi=713236699538&gai=1%3A713236699538%3Aandroid%3A009a2ac813852ff27b094b&gak=AIzaSyC63n3QJFPFybjo85S269Ip9fT38bRPgt0&device_name=SAMSUNG+SM-A507FN%2811%29&version_name=77VPN-V6&build_id=FIRST_BUILD&action=app_data',
        CURLOPT_HTTPHEADER => [
            'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:108.0) Gecko/1381234 Firefox/108.0',
            'Accept-Encoding: gzip',
            'Content-Type: application/x-www-form-urlencoded',
            'Cache-Control: no-cache',
            'Accept-Language: en-US,en;q=0.5',
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $decrypted = decrypt($response);
    $cachedData = json_decode($decrypted, true);
    cacheData($cacheFile, $cachedData);
}

if (!empty($cachedData['result']['free_servers'])) {
    $servers = $cachedData['result']['free_servers'];
    shuffle($servers); // شافل برای تصادفی کردن سرورها
    $server = $servers[0]; // اولین سرور از لیست تصادفی

    $decode = base64_decode($server['vpn_server_config']);
    $data = json_decode($decode, true);

    if ($data !== null) {
        $protocol = $data['outbounds'][0]['protocol'];
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id'];
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address'];
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port'];
        $security = $data['outbounds'][0]['streamSettings']['security'];
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn'];
        $type = $data['outbounds'][0]['streamSettings']['network'];
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host'];
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path'];

        if ($protocol == 'vless') {
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn={$alpn['0']}{$alpn['1']}&host={$host}&path={$path}#Server";
            echo $v2ary_vless;
        } else {
            $v2ary_vmess = 'vmess://'.base64_encode('{"add":"'.$address.'","aid":"0","alpn":"'.$alpn['0'].$alpn['1'].'","fp":"","host":"","id":"'.$uuid.'","net":"'.$type.'","path":"'.$path.'","port":"'.$port.'","ps":"new server","scy":"auto","sni":"'.$tlsSni.'","tls":"","type":"'.$type.'","v":"2"}');
            echo $v2ary_vmess;
        }
    }
}
?>
