<?php
header("Content-Type: text/plain; charset=utf-8");

$url = "https://raw.githubusercontent.com/IranianCypherpunks/Xray/main/Sub";
$cacheFile = __DIR__ . "/vless_cache.json";
$cacheTTL = 17200; // 2 ساعت

// استفاده از کش در صورت معتبر بودن
if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTTL)) {
    $json = file_get_contents($cacheFile);
} else {
    $json = @file_get_contents($url);
    if ($json !== false) {
        file_put_contents($cacheFile, $json);
    } elseif (file_exists($cacheFile)) {
        $json = file_get_contents($cacheFile); // استفاده از کش قدیمی در صورت خطا
    } else {
        exit; // نه کش هست نه دریافت موفق
    }
}

$data = json_decode($json, true);
if (!is_array($data)) exit;

// تابع ساخت لینک vless://
function generateVlessLink($config) {
    foreach ($config['outbounds'] as $out) {
        if ($out['protocol'] !== 'vless') continue;

        $vnext = $out['settings']['vnext'][0] ?? null;
        if (!$vnext) return null;

        $address = $vnext['address'] ?? '';
        $port = $vnext['port'] ?? '';
        $uuid = $vnext['users'][0]['id'] ?? '';
        $encryption = $vnext['users'][0]['encryption'] ?? 'none';

        $network = $out['streamSettings']['network'] ?? '';
        $security = $out['streamSettings']['security'] ?? 'none';
        $sni = $out['streamSettings']['tlsSettings']['serverName'] ?? '';
        $path = $out['streamSettings'][$network . 'Settings']['path'] ?? '';
        $mode = $out['streamSettings'][$network . 'Settings']['mode'] ?? '';
        $fp = 'chrome';

        $params = [
            "encryption=$encryption",
            "security=$security",
            "type=$network",
        ];
        if ($sni)  $params[] = "sni=$sni";
        if ($path) $params[] = "path=" . urlencode($path);
        if ($mode) $params[] = "mode=$mode";
        if ($fp)   $params[] = "fp=$fp";

        $remark = $config['remarks'] ?? '';

        return "vless://$uuid@$address:$port?" . implode("&", $params) . "#" . urlencode($remark);
    }

    return null;
}

// چاپ فقط لینک‌های vless:// به‌صورت مرتب و بدون خروجی اضافه
foreach ($data as $conf) {
    $link = generateVlessLink($conf);
    if ($link) echo $link . "\n";
}