<?php

// دریافت محتویات لینک
$url = "https://fitn1.ir/Api/Ash/trun.php";
$data = trim(file_get_contents($url));

if (!$data) {
    die(json_encode(["error" => "empty config source"]));
}

$lines = array_filter(explode("\n", $data));

// متغیر خروجی
$config = null;

// پردازش لینک‌ها
foreach ($lines as $line) {
    $line = trim($line);

    if (stripos($line, "vless://") === 0) {
        $config = buildVless($line);
        break;
    }

    if (stripos($line, "trojan://") === 0) {
        $config = buildTrojan($line);
        break;
    }
}

if (!$config) {
    die(json_encode(["error" => "no valid vless or trojan link found"]));
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);



// =========================
//      توابع تبدیل لینک‌ها
// =========================

function buildVless($url)
{
    $parts = parse_url($url);
    parse_str($parts['query'] ?? '', $q);

    $uuid = $parts['user'];
    $server = $parts['host'];
    $port = intval($parts['port'] ?? 443);
    $security = $q["security"] ?? "none";
    $network = $q["type"] ?? "tcp";
    $flow = $q["flow"] ?? null;

    return baseConfig([
        "protocol" => "vless",
        "vnext" => [[
            "address" => $server,
            "port" => $port,
            "users" => [[
                "id" => $uuid,
                "encryption" => "none",
                "flow" => $flow
            ]]
        ]],
        "stream" => buildStream($network, $security, $q)
    ]);
}

function buildTrojan($url)
{
    $parts = parse_url($url);
    parse_str($parts['query'] ?? '', $q);

    $password = $parts['user'];
    $server = $parts['host'];
    $port = intval($parts['port'] ?? 443);
    $network = $q["type"] ?? "tcp";
    $security = $q["security"] ?? "tls";

    return baseConfig([
        "protocol" => "trojan",
        "servers" => [[
            "address" => $server,
            "port" => $port,
            "password" => $password
        ]],
        "stream" => buildStream($network, $security, $q)
    ]);
}



// =========================
//     ساخت StreamSettings
// =========================

function buildStream($network, $security, $q)
{
    $stream = [
        "network" => $network,
        "security" => $security,
        "allowInsecure" => true
    ];

    if ($security === "reality") {
        $stream["realitySettings"] = [
            "show" => false,
            "fingerprint" => $q["fp"] ?? "chrome",
            "publicKey" => $q["pbk"] ?? "",
            "serverName" => $q["sni"] ?? "",
            "allowInsecure" => true
        ];
    }

    if ($network === "tcp") {
        $stream["tcpSettings"] = [
            "header" => ["type" => "none"]
        ];
    }

    if ($network === "ws") {
        $stream["wsSettings"] = [
            "path" => $q["path"] ?? "/",
            "headers" => ["Host" => $q["host"] ?? ""]
        ];
    }

    if ($network === "grpc") {
        $stream["grpcSettings"] = [
            "serviceName" => $q["serviceName"] ?? "grpc"
        ];
    }

    return $stream;
}



// =========================
//     قالب ثابت کانفیگ
// =========================

function baseConfig($data)
{
    return [
        "log" => [
            "loglevel" => "warning"
        ],
        "dns" => [
            "servers" => ["1.1.1.1", "8.8.8.8"]
        ],
        "inbounds" => [[
            "listen" => "127.0.0.1",
            "port" => 10808,
            "protocol" => "socks",
            "settings" => [
                "auth" => "noauth",
                "udp" => true
            ],
            "tag" => "socks"
        ]],
        "outbounds" => [[
            "protocol" => $data["protocol"],
            "settings" =>
                $data["protocol"] === "vless"
                ? ["vnext" => $data["vnext"]]
                : ["servers" => $data["servers"]],
            "streamSettings" => $data["stream"],
            "tag" => "proxy",
            "allowInsecure" => true
        ], [
            "protocol" => "freedom",
            "tag" => "direct"
        ]],
        "routing" => [
            "rules" => []
        ]
    ];
}