<?php

function fetchConfig($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return trim($response);
}

function array_filter_recursive($input) {
    foreach ($input as $key => &$value) {
        if (is_array($value)) {
            $value = array_filter_recursive($value);
        }
        if ($value === null || (is_array($value) && empty($value))) {
            unset($input[$key]);
        }
    }
    return $input;
}

function getNextFragmentAndMux() {
    $variants = [
        [["length" => [10, 20], "interval" => [2, 3]], [8, 4]],
        [["length" => [30, 50], "interval" => [1, 2]], [16, 8]],
        [["length" => [15, 25], "interval" => [1, 3]], [12, 6]],
        [["length" => [20, 40], "interval" => [2, 4]], [10, 4]],
        [["length" => [25, 35], "interval" => [1, 2]], [14, 7]]
    ];
    $file = 'counter.txt';
    $index = 0;
    if (file_exists($file)) $index = (int)file_get_contents($file);
    $selected = $variants[$index % count($variants)];
    file_put_contents($file, ($index + 1) % count($variants));
    return $selected;
}

function buildStreamSettings($network, $security, $sni, $host, $path, $grpcServiceName, $extra = [], $fragment = [], $mux = []) {
    $base = [
        "network" => $network,
        "security" => $security,
        "sockopt" => [
            "tcpFastOpen" => true,
            "TcpNoDelay" => true,
            "mark" => 255
        ]
    ];

    if (in_array($security, ["tls", "xtls", "xhttp", "http"])) {
        $base["tlsSettings"] = ["allowInsecure" => true, "serverName" => $sni];
    } elseif ($security === "reality") {
        $base["security"] = "reality";
        $base["realitySettings"] = [
            "show" => false,
            "fingerprint" => $extra['fingerprint'] ?? 'chrome',
            "serverName" => $sni,
            "publicKey" => $extra['publicKey'] ?? '',
            "shortId" => $extra['shortId'] ?? '',
            "spiderX" => $extra['spiderX'] ?? '/'
        ];
    }

    if ($network === "ws") {
        $base["wsSettings"] = ["path" => $path, "headers" => ["Host" => $host]];
    } elseif ($network === "grpc") {
        $base["grpcSettings"] = ["serviceName" => $grpcServiceName, "multiMode" => true];
    }

    $base["fragment"] = [
        "length" => $fragment['length'],
        "interval" => $fragment['interval'],
        "tlshello" => true
    ];

    return [$base, ["enabled" => true, "concurrency" => $mux[0], "xudpConcurrency" => $mux[1]]];
}

function parseV2RayConfig($config) {
    $config = trim($config);
    list($fragment, $mux) = getNextFragmentAndMux();

    $protocol = '';
    $address = '';
    $port = 443;
    $id = '';
    $network = 'tcp';
    $security = 'tls';
    $path = '/';
    $host = '';
    $sni = '';
    $grpcServiceName = 'grpc';
    $extra = [];

    if (strpos($config, 'vmess://') === 0) {
        $json = json_decode(base64_decode(substr($config, 8)), true);
        if (!$json) return json_encode(["error" => "Broken vmess config"]);

        $protocol = 'vmess';
        $address = $json['add'] ?? '';
        $port = (int)($json['port'] ?? 443);
        $id = $json['id'] ?? '';
        $network = strtolower($json['net'] ?? 'tcp');
        $security = strtolower($json['tls'] ?? 'none');
        $path = $json['path'] ?? '/';
        $host = $json['host'] ?? '';
        $sni = $json['sni'] ?? $host;
        $grpcServiceName = $json['serviceName'] ?? 'grpc';

        $userConfig = [
            "vnext" => [[
                "address" => $address,
                "port" => $port,
                "users" => [[
                    "id" => $id,
                    "encryption" => "none",
                    "level" => 8
                ]]
            ]]
        ];

    } elseif (preg_match('/^(vless|trojan):\/\//', $config)) {
        $parsed = parse_url($config);
        parse_str($parsed['query'] ?? '', $q);

        $protocol = $parsed['scheme'];
        $address = $parsed['host'];
        $port = isset($parsed['port']) ? (int)$parsed['port'] : 443;
        $id = $parsed['user'];
        $network = strtolower($q['type'] ?? 'tcp');
        $security = strtolower($q['security'] ?? 'tls');
        $path = $q['path'] ?? '/';
        $host = $q['host'] ?? '';
        $sni = $q['sni'] ?? $host;
        $grpcServiceName = $q['serviceName'] ?? 'grpc';

        if ($security === 'reality') {
            $extra = [
                'publicKey' => $q['pbk'] ?? '',
                'shortId' => $q['sid'] ?? '',
                'fingerprint' => $q['fp'] ?? 'chrome',
                'spiderX' => $q['spx'] ?? '/'
            ];
        }

        if ($protocol === 'trojan') {
            $userConfig = [
                "servers" => [[
                    "address" => $address,
                    "port" => $port,
                    "password" => $id,
                    "level" => 8
                ]]
            ];
        } else {
            $userConfig = [
                "vnext" => [[
                    "address" => $address,
                    "port" => $port,
                    "users" => [[
                        "id" => $id,
                        "encryption" => "none",
                        "level" => 8
                    ]]
                ]]
            ];
        }

    } else {
        return json_encode(["error" => "Unsupported config format"]);
    }

    list($streamSettings, $muxSettings) = buildStreamSettings($network, $security, $sni, $host, $path, $grpcServiceName, $extra, $fragment, $mux);

    $json = [
        "dns" => [
            "servers" => ["1.1.1.1", "8.8.8.8"]
        ],
        "inbounds" => [
            [
                "listen" => "127.0.0.1",
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "enabled" => true,
                    "destOverride" => ["http", "tls"]
                ],
                "tag" => "socks"
            ],
            [
                "listen" => "127.0.0.1",
                "port" => 8080,
                "protocol" => "http",
                "settings" => ["timeout" => 360],
                "tag" => "http-in"
            ]
        ],
        "log" => ["loglevel" => "debug"],
        "outbounds" => [
            [
                "protocol" => $protocol,
                "tag" => "proxy",
                "mux" => $muxSettings,
                "streamSettings" => $streamSettings,
                "settings" => $userConfig
            ],
            [
                "protocol" => "blackhole",
                "tag" => "blocked"
            ]
        ],
        "policy" => [
            "levels" => [
                "8" => [
                    "connIdle" => 600,
                    "downlinkOnly" => 5,
                    "handshake" => 5,
                    "uplinkOnly" => 5
                ]
            ],
            "system" => [
                "statsOutboundUplink" => true,
                "statsOutboundDownlink" => true
            ]
        ],
        "routing" => [
            "domainStrategy" => "IPIfNonMatch",
            "rules" => [
                [
                    "type" => "field",
                    "domain" => ["geosite:geolocation-!cn"],
                    "outboundTag" => "proxy"
                ],
                [
                    "type" => "field",
                    "ip" => ["geoip:!cn"],
                    "outboundTag" => "proxy"
                ],
                [
                    "type" => "field",
                    "ip" => ["geoip:cn", "geoip:private"],
                    "outboundTag" => "blocked"
                ],
                [
                    "type" => "field",
                    "domain" => ["geosite:cn", "geosite:category-games@cn"],
                    "outboundTag" => "blocked"
                ]
            ]
        ],
        "stats" => new stdClass()
    ];

    return json_encode(array_filter_recursive($json), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$url = "https://fitn1.ir/Api/Ash/trun.php";
$configData = fetchConfig($url);
echo parseV2RayConfig($configData);

?>