<?php
header('Content-type: text/plain');

function extractVlessLink($outbound, $name = 'hoo$') {
    $protocol = $outbound['protocol'] ?? '';
    if (!in_array($protocol, ['vless', 'vmess', 'trojan', 'shadowsocks'])) {
        return null;
    }

    $settings = $outbound['settings']['vnext'][0] ?? null;
    $streamSettings = $outbound['streamSettings'] ?? [];

    if (!$settings) {
        return null;
    }

    $uuid = $settings['users'][0]['id'] ?? '';
    $address = $settings['address'] ?? '';
    $port = $settings['port'] ?? '';

    $network = $streamSettings['network'] ?? '';
    $security = $streamSettings['security'] ?? 'none';

    // Reality handling
    $sni = $streamSettings['realitySettings']['serverName'] ?? ($streamSettings['tlsSettings']['serverName'] ?? $address);
    $fp = $streamSettings['tlsSettings']['fingerprint'] ?? 'chrome'; // اگر نبود fingerprint پیشفرض chrome
    $pbk = $streamSettings['realitySettings']['publicKey'] ?? '';
    $sid = $streamSettings['realitySettings']['shortId'] ?? '';
    $spx = $streamSettings['realitySettings']['spiderX'] ?? '';

    $alpn = isset($streamSettings['tlsSettings']['alpn']) ? implode(',', $streamSettings['tlsSettings']['alpn']) : '';

    $host = '';
    $path = '/';

    if ($network === 'ws' && isset($streamSettings['wsSettings'])) {
        $host = $streamSettings['wsSettings']['headers']['Host'] ?? $address;
        $path = $streamSettings['wsSettings']['path'] ?? '/';
    } elseif ($network === 'grpc' && isset($streamSettings['grpcSettings'])) {
        $path = $streamSettings['grpcSettings']['serviceName'] ?? '';
        $host = $sni;
    } elseif ($network === 'tcp' && isset($streamSettings['tcpSettings']['header']['type']) && $streamSettings['tcpSettings']['header']['type'] === 'http') {
        $path = '/';
        $host = $streamSettings['tcpSettings']['header']['request']['headers']['Host'][0] ?? $address;
    }

    if ($protocol === 'vless') {
        $query = [
            'encryption' => 'none',
            'security' => $security,
            'sni' => $sni,
            'alpn' => $alpn,
            'type' => $network,
        ];
        if ($host) $query['host'] = $host;
        if ($path) $query['path'] = $path;
        if ($security === 'reality') {
            $query['fp'] = $fp;
            $query['pbk'] = $pbk;
            $query['sid'] = $sid;
            $query['spx'] = $spx;
        }
        $query_string = http_build_query($query, '', '&', PHP_QUERY_RFC3986);
        return "vless://{$uuid}@{$address}:{$port}?{$query_string}#{$name}\n\n";
    } elseif ($protocol === 'vmess') {
        $vmess = [
            "v" => "2",
            "ps" => $name,
            "add" => $address,
            "port" => (string)$port,
            "id" => $uuid,
            "aid" => "0",
            "net" => $network,
            "type" => "none",
            "host" => $host,
            "path" => $path,
            "tls" => ($security === 'tls' || $security === 'reality') ? 'tls' : '',
            "sni" => $sni,
            "alpn" => $alpn,
            "fp" => $fp,
        ];
        return "vmess://" . base64_encode(json_encode($vmess, JSON_UNESCAPED_SLASHES)) . "\n\n";
    } else {
        return null;
    }
}

// ================== دریافت و چاپ ===================

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'https://api-breakk.vetramain.com/app/?action=app_data_slice',
  CURLOPT_RETURNTRANSFER => true,
]);
$response = json_decode(curl_exec($curl), true)['result']['free_servers'];
curl_close($curl);

foreach ($response as $value) {
    $p = base64_decode($value['vpn_server_config']);
    $s = openssl_decrypt(
        $p,
        'AES-256-ECB',
        hex2bin('ce0f2868988e8d90c1b58cc73c50c067e6a590508df2faa1cf0eec88de422b52'),
        OPENSSL_RAW_DATA
    );

    $decoded = json_decode(str_replace('\n', '', $s), true);

    if (isset($decoded['outbounds'])) {
        foreach ($decoded['outbounds'] as $outbound) {
            $link = extractVlessLink($outbound);
            if ($link) {
                echo $link;
            }
        }
    }
}
?>