<?php

// تنظیمات کش
$cacheFile = 'cache.txt'; // فایل کش
$cacheTime = 6 * 60; // 63 دقیقه

// بررسی اینکه آیا فایل کش موجود است و مدت زمان کش منقضی نشده است
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    // بارگذاری داده‌های کش شده
    $response = file_get_contents($cacheFile);
} else {
    // دریافت داده‌ها از API
    $url = "https://fitn1.ir/Api/Avox/Avox.php";
    $response = file_get_contents($url);

    if ($response === false) {
        die("خطا در دریافت داده از API");
    }

    // ذخیره داده‌ها در فایل کش
    file_put_contents($cacheFile, $response);
}

// تعریف الگوها برای انواع کانفیگ‌ها
$patterns = [
    'vless' => '/(vless:\/\/[^\s]+)/',
    'vmess' => '/(vmess:\/\/[^\s]+)/',
    'trojan' => '/(trojan:\/\/[^\s]+)/'
];

$configs = [];

// استخراج کانفیگ‌ها بر اساس الگوها
foreach ($patterns as $pattern) {
    if (preg_match_all($pattern, $response, $matches)) {
        $configs = array_merge($configs, $matches[0]);
    }
}

// بررسی اینکه آیا داده‌ای برای پردازش وجود دارد
if (empty($configs)) {
    die("داده‌ای برای نمایش وجود ندارد");
}

// انتخاب یک کانفیگ به صورت تصادفی
$config = $configs[array_rand($configs)];

// چاپ کانفیگ
echo $config;

?>