<?php
header('Content-type: application/json');

// توابع اصلی
function country2flag(string $countryCode): string {
    return (string) preg_replace_callback(
        '/./',
        static fn (array $letter) => mb_chr(ord($letter[0]) % 32 + 0x1F1E5),
        $countryCode
    );
}

function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x', mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0x0fff) | 0x4000, mt_rand(0, 0x3fff) | 0x8000, mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff));
}

// مسیر فایل کش
$cacheFile = 'cache.json';
$cacheTTL = 120; // زمان کش: 120 ثانیه

// بررسی وضعیت کش
if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTTL)) {
    $cachedData = json_decode(file_get_contents($cacheFile), true);
} else {
    // درخواست جدید از API
    $userID = generateUUID();
    $deviceModel = "Model_" . rand(1000, 9999);
    $deviceManufacturer = "Manufacturer_" . rand(100, 999);
    $data = [
        "userID" => $userID,
        "deviceModel" => $deviceModel,
        "deviceManufacturer" => $deviceManufacturer,
        "deviceSdkVersion" => "29",
        "deviceAppVersion" => "1.0.8",
    ];
    $headers = [
        "Authorization: Bearer 215b4322-39d9-47f4-be5d-89174f58a587",
        "Content-Type: application/json; charset=utf-8",
        "Connection: Keep-Alive",
        "User-Agent: okhttp/4.11.0"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.berdvpn.com/v1/api/User/createUser");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $userID = json_decode(curl_exec($ch), true)['userID'];
    curl_close($ch);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.berdvpn.com/v1/api/Server/all");
    curl_setopt($ch, CURLOPT_HTTPGET, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response2 = json_decode(curl_exec($ch), true);
    curl_close($ch);

    $configs = [];
    foreach ($response2 as $config) {
        $ch = curl_init("https://api.berdvpn.com/v1/api/Access/get?serverId={$config['identity']}&userId=$userID");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        $encode = urlencode(base64_encode($response['method'] . ':' . $response['password']));
        $flag = country2flag($config['countryCode']);
        $configs[] = "ss://$encode@{$response['accessIP']}:{$response['accessPort']}#$flag  {$config['name']}-{$config['city']}";
    }

    // ذخیره در فایل کش
    file_put_contents($cacheFile, json_encode($configs));
    $cachedData = $configs;
}

// چاپ یک کانفیگ به صورت تصادفی
if (!empty($cachedData)) {
    shuffle($cachedData); // مرتب‌سازی تصادفی
    echo array_pop($cachedData) . "\n"; // چاپ یک کانفیگ و حذف آن از لیست
    file_put_contents($cacheFile, json_encode($cachedData)); // ذخیره مجدد لیست به‌روز شده
}
?>
