<?php
header('Content-Type: application/json');

function jsonserver($vlessJson, $name) {
    $decoded_data = json_decode($vlessJson);
    if ($decoded_data !== null) {
        $data = json_decode($vlessJson, true);
        $protocol = $data['outbounds'][0]['protocol'];
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id'];
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address'];
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port'];
        $security = $data['outbounds'][0]['streamSettings']['security'];
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn'];
        $type = $data['outbounds'][0]['streamSettings']['network'];
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host'];
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path'];
        if ($protocol == 'vless') {
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn={$alpn['0']}{$alpn['1']}&host={$host}&path={$path}#$name";
            return $v2ary_vless . "  \n\n";
        } else {
            $v2ary_vmess = 'vmess://' . base64_encode('{"add":"' . $address . '","aid":"0","alpn":"' . $alpn['0'] . $alpn['1'] . '","fp":"","host":"","id":"' . $uuid . '","net":"' . $type . '","path":"' . $path . '","port":"' . $port . '","ps":"new server","scy":"auto","sni":"' . $tlsSni . '","tls":"","type":"' . $type . '","v":"2"}');
            return $v2ary_vmess . "  \n\n";
        }
    } else {
        return $vlessJson . "  \n\n";
    }
}

function replaceCharacters($inputString) {
    $original = "!@#$%&*)(_-+=0987654321ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba";
    $replacement = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890=+-_()*&%$#@!";
    $replacementArray = array();
    for ($i = 0; $i < strlen($original); $i++) {
        $replacementArray[$original[$i]] = $replacement[$i];
    }
    $outputString = '';
    for ($j = 0; $j < strlen($inputString); $j++) {
        $currentChar = $inputString[$j];
        if (array_key_exists($currentChar, $replacementArray)) {
            $outputString .= $replacementArray[$currentChar];
        } else {
            $outputString .= $currentChar;
        }
    }

    return $outputString;
}

function decrypt($str) {
    $cipher = "AES-128-CBC";
    $decrypted = openssl_decrypt(base64_decode($str), $cipher, 'utmtrnwxlukklphg', OPENSSL_RAW_DATA, 'utmtrnwxlukklphg');
    return replaceCharacters($decrypted);
}

function fetchServersFromApi() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'http://marsoomateiranenovin.com/ClientV3/getServers',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => 'Locale=en&CellphoneBrand=Google&ApplicationVersionCode=4&Oprtr=Mobile+Communication+Company&InstallationSource=com.android.vending&PackageName=com.vpn.atlanticvpn&LocaleCountryCode=US&Isp=Mobile+Communication+Company+of+Iran&AndroidId=9e2bef49b4b4f369&CellphoneModel=Pixel&SimCardName=Android&IsIranian=true&sh=qtwrsnson&UserId=0&runCount=0&CountryCode=IR&IsConnected=false&',
        CURLOPT_HTTPHEADER => [
            'User-Agent: Dalvik/2.1.0 (Linux; U; Android 10; Galaxy S5 Build/QQ1D.200105.002)',
            'Connection: Keep-Alive',
            'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
        ],
    ]);
    $response = json_decode(curl_exec($curl), true);
    curl_close($curl);

    return array_map(function ($server) {
        return decrypt($server['server']['ovpnFileBody']);
    }, $response['connectionRequests']);
}

function getCachedServers() {
    $cacheFile = 'cache.json';
    $cacheDuration = 5 * 60; // 5 minutes in seconds

    if (file_exists($cacheFile)) {
        $cacheData = json_decode(file_get_contents($cacheFile), true);
        $lastUpdated = $cacheData['lastUpdated'] ?? 0;

        if (time() - $lastUpdated < $cacheDuration) {
            return $cacheData['servers'];
        }
    }

    // Fetch from API and update cache
    $servers = fetchServersFromApi();
    file_put_contents($cacheFile, json_encode(['lastUpdated' => time(), 'servers' => $servers]));

    return $servers;
}

function printNextServer() {
    $indexFile = 'index.json';
    $servers = getCachedServers();
    $totalServers = count($servers);

    // Load or initialize index
    $currentIndex = 0;
    if (file_exists($indexFile)) {
        $indexData = json_decode(file_get_contents($indexFile), true);
        $currentIndex = ($indexData['currentIndex'] + 1) % $totalServers;
    }

    // Save the new index
    file_put_contents($indexFile, json_encode(['currentIndex' => $currentIndex]));

    // Transform the server configuration with jsonserver
    $serverName = "Server " . ($currentIndex + 1);
    $transformedServer = jsonserver($servers[$currentIndex], $serverName);

    // Print the transformed server configuration
    echo $transformedServer;
}

// Print the next server
printNextServer();
