<?php
header('Content-Type: text/plain; charset=utf-8');

/**
 * هِلپر خواندن امن مقدار از آرایه با مسیر چندسطحی
 */
function val($arr, $path, $default = null) {
    $ref = $arr;
    foreach ($path as $k) {
        if (!is_array($ref) || !array_key_exists($k, $ref)) return $default;
        $ref = $ref[$k];
    }
    return $ref;
}

/**
 * تبدیل JSON کانفیگ Xray/V2Ray به لینک ساده (VLESS Reality / TLS / VMess)
 */
function jsonserver(string $vlessJson, string $fallbackName = 'server') {
    $data = json_decode($vlessJson, true);
    if (!is_array($data)) {
        // اگر ورودی خودش لینک ساده بود، همان را برگردان
        return trim($vlessJson) . "\n";
    }

    // پیدا کردن اولین outbound مناسب
    $outbounds = val($data, ['outbounds'], []);
    if (!is_array($outbounds) || empty($outbounds)) {
        return "# invalid config: no outbounds\n";
    }

    $ob = null;
    foreach ($outbounds as $o) {
        if (isset($o['protocol']) && in_array($o['protocol'], ['vless','vmess','trojan'])) {
            $ob = $o;
            break;
        }
    }
    if (!$ob) $ob = $outbounds[0];

    $protocol = val($ob, ['protocol'], '');
    $network  = val($ob, ['streamSettings','network'], 'tcp');
    $security = val($ob, ['streamSettings','security'], '');
    $sni      = val($ob, ['streamSettings','tlsSettings','serverName'], '');
    $alpn     = val($ob, ['streamSettings','tlsSettings','alpn'], []);
    $host     = val($ob, ['streamSettings','wsSettings','headers','Host'], '');
    $path     = val($ob, ['streamSettings','wsSettings','path'], '');
    $quicSec  = val($ob, ['streamSettings','quicSettings','security'], '');
    $vnext    = val($ob, ['settings','vnext',0], []);
    $addr     = val($vnext, ['address'], '');
    $port     = val($vnext, ['port'], '');
    $user0    = val($vnext, ['users',0], []);

    // Reality fields
    $pbk   = val($ob, ['streamSettings','realitySettings','publicKey'], '');
    $sid   = val($ob, ['streamSettings','realitySettings','shortId'], '');
    $fp    = val($ob, ['streamSettings','realitySettings','fingerprint'], 'chrome');
    $spx   = val($ob, ['streamSettings','realitySettings','spiderX'], '/');
    $sniR  = val($ob, ['streamSettings','realitySettings','serverName'], $sni);

    // مقادیر کاربر
    $uuid  = val($user0, ['id'], '');
    $flow  = val($user0, ['flow'], '');
    $enc   = val($user0, ['encryption'], 'none');

    // نام (اگر داشتی از hostname/remarks بیرون بده؛ در غیر این صورت fallback)
    $name = $fallbackName;

    // ساخت لینک بر اساس پروتکل/سکیوریتی
    if ($protocol === 'vless') {
        // VLESS Reality
        if (strtolower($security) === 'reality' || $pbk) {
            $q = [
                'encryption' => $enc ?: 'none',
                'security'   => 'reality',
                'sni'        => $sniR ?: $sni,
                'fp'         => $fp ?: 'chrome',
                'pbk'        => $pbk,
                'sid'        => $sid,
                'type'       => $network ?: 'tcp',
            ];
            if ($flow) $q['flow'] = $flow;
            // spiderX باید URL-encode شود و به‌صورت پارامتر spx بیاید
            if ($spx !== null && $spx !== '') $q['spx'] = $spx;

            // ساخت querystring
            $qs = http_build_query($q, '', '&', PHP_QUERY_RFC3986);
            $tag = rawurlencode($name);

            return "vless://{$uuid}@{$addr}:{$port}?{$qs}#{$tag}\n";
        }

        // VLESS + TLS/WS/gRPC (غیر-Reality)
        $q = [
            'encryption' => $enc ?: 'none',
        ];
        if ($security) $q['security'] = $security;
        if ($sni)      $q['sni']      = $sni;
        if (!empty($alpn)) $q['alpn'] = implode(',', $alpn);
        if ($network)  $q['type']     = $network;

        // WS
        if ($network === 'ws') {
            if ($host) $q['host'] = $host;
            if ($path) $q['path'] = $path;
        }

        $qs  = http_build_query($q, '', '&', PHP_QUERY_RFC3986);
        $tag = rawurlencode($name);
        return "vless://{$uuid}@{$addr}:{$port}?{$qs}#{$tag}\n";
    }

    if ($protocol === 'vmess') {
        // ساخت vmess base64
        $vm = [
            'v'   => '2',
            'ps'  => $name,
            'add' => $addr,
            'port'=> (string)$port,
            'id'  => $uuid,
            'aid' => '0',
            'scy' => 'auto',
            'net' => $network ?: 'tcp',
            'type'=> $network ?: 'tcp',
            'host'=> $host ?: '',
            'path'=> $path ?: '',
            'sni' => $sni ?: '',
            'alpn'=> !empty($alpn) ? implode(',', $alpn) : '',
            'tls' => ($security && strtolower($security) !== 'none') ? $security : '',
            'fp'  => '',
        ];
        $b64 = base64_encode(json_encode($vm, JSON_UNESCAPED_SLASHES));
        return "vmess://{$b64}\n";
    }

    // پروتکل‌های دیگر (trojan و …) — حداقل آدرس را برگردانیم
    return "# unsupported protocol: {$protocol}\n";
}

// ====== دریافت لیست سرورها از API شما ======
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'http://92.205.28.41:4001/bull/all?app=bullvpn&country=Iran&debug=false&package=com.hdesign.bullvpn&city=Tehran&signature=s0PQ0gPzv9ay9TChZcG4R9Ouy44%3D&isp=Mobile%20Communication%20Company%20of%20Iran&lon=51.4043&isAdmin=false&locale=en&versionName=1.0&userId=8478e6ec3e2fa562&version=1&operator=Orange&device_info=Xiaomi%20MI%209&i_operator=null&installationSource=com.android.vending&region=Tehran&lat=35.7607',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_TIMEOUT => 20,
]);
$respRaw = curl_exec($curl);
if ($respRaw === false) {
    echo "# curl error: " . curl_error($curl) . "\n";
    exit;
}
curl_close($curl);

$response = json_decode($respRaw, true);
if (!is_array($response) || empty($response['servers'])) {
    echo "# invalid API response\n";
    // اگر می‌خواهی raw را ببینی، باز کن:
    // echo $respRaw, "\n";
    exit;
}

// چاپ لینک ساده برای هر سرور
foreach ($response['servers'] as $i => $srv) {
    $name = val($srv, ['hostname'], 'server-'.($i+1));
    $conf = val($srv, ['config'], '');
    echo jsonserver($conf, $name);
}