<?php
header('Content-type: application/json');
function decrypt_config($config_code, $token, $key_str) {
    $bytes = $key_str . $token;
    $key = hash('sha256', $bytes, true);
    $decode = base64_decode($config_code);
    $nonce = substr($decode, 0, 12);
    $tag = substr($decode, -16);
    $ciphertext = substr($decode, 12, -16);

    $plaintext = openssl_decrypt($ciphertext,'aes-256-gcm',$key,OPENSSL_RAW_DATA,$nonce,$tag);

    return $plaintext !== false ? $plaintext : '';
}


function generateRandomDeviceId($length) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
function jsonserver($vlessJson,$name = 'nima'){ 
    $decoded_data = json_decode($vlessJson); 
    if($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security']; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 
        if($protocol == 'vless'){
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn={$alpn['0']}{$alpn['1']}&host={$host}&path={$path}#".$data['remarks']; 
            return $v2ary_vless."  \n\n";
        }else{
            $v2ary_vmess = 'vmess://'.base64_encode('{"add":"'.$address.'","aid":"0","alpn":"'.$alpn['0'].$alpn['1'].'","fp":"","host":"","id":"'.$uuid.'","net":"'.$type.'","path":"'.$path.'","port":"'.$port.'","ps":"new server","scy":"auto","sni":"'.$tlsSni.'","tls":"","type":"'.$type.'","v":"2"}');
            return $v2ary_vmess."  \n\n";
        }
    }else{
        return $vlessJson."  \n\n"; 
    }
}
//===================
$headers = [
    'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
    'User-Agent: Dalvik/2.1.0 (Linux; U; Android 9; ROG Phone 7 Ultimate Build/PQ3B.190801.12191611)',
];
//===============
$s = generateRandomDeviceId(16);
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'https://www.lib2023.site/vping/load_data.php',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'action=all_apis&username1=xcodemaster_vip&password1=970922&app_version_name=17&app_version_code=17&android_id='.$s.'&signature=295f671d966cb54b187dcd0f73ddd18aa8b5ce1d49186391346180cd54199c0d&lib_folder_file_ist=%D9%81%D8%A7%DB%8C%D9%84%E2%80%8C%D9%87%D8%A7%DB%8C%20%D9%85%D9%88%D8%AC%D9%88%D8%AF%20%D8%AF%D8%B1%20lib%3A%0Alibmylibc1.so%0Alibmylibsoc.so%0Alibmylibc3.so%0Alibmmkv.so%0Alibtun2socks.so%0Alibgojni.so%0Alibmylibc2.so%0Alibimage_processing_util_jni.so%0Alibmylibc.so%0Alibdatastore_shared_counter.so%0A&assets_folder_file_ist=%D9%81%D8%A7%DB%8C%D9%84%E2%80%8C%D9%87%D8%A7%DB%8C%20%D9%85%D9%88%D8%AC%D9%88%D8%AF%20%D8%AF%D8%B1%20assets%3A%0Acustom_routing_black%0Acustom_routing_global%0Acustom_routing_white%0Acustom_routing_white_iran%0Adexopt%0Ageoip.dat%0Ageosite.dat%0Aimages%0Aopen_source_licenses.html%0Aproxy_packagename.txt%0Av2ray_config.json%0Awebkit%0A&manifest_permission_list=Permissions%3A%0Aandroid.permission.POST_NOTIFICATIONS%0Aandroid.permission.QUERY_ALL_PACKAGES%0Aandroid.permission.ACCESS_NETWORK_STATE%0Aandroid.permission.CHANGE_NETWORK_STATE%0Aandroid.permission.INTERNET%0Acom.google.android.gms.permission.AD_ID%0Aandroid.permission.FOREGROUND_SERVICE%0Aandroid.permission.FOREGROUND_SERVICE_SPECIAL_USE%0Aandroid.permission.RECEIVE_BOOT_COMPLETED%0Aandroid.permission.WAKE_LOCK%0Acom.google.android.c2dm.permission.RECEIVE%0Acom.android.vending.BILLING%0Acom.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE%0Aandroid.permission.ACCESS_ADSERVICES_AD_ID%0Aandroid.permission.ACCESS_ADSERVICES_ATTRIBUTION%0Aandroid.permission.ACCESS_ADSERVICES_TOPICS%0Acom.xcodemaster.carenvpn.DYNAMIC_RECEIVER_NOT_EXPORTED_PERMISSION%0Acom.android.vending.CHECK_LICENSE%0A%0AActivities%3A%0Acom.xcodemaster.carenvpn.ui.MainActivity%0Acom.xcodemaster.carenvpn.ui.ServerActivity%0Acom.xcodemaster.carenvpn.ui.ServerCustomConfigActivity%0Acom.xcodemaster.carenvpn.ui.SettingsActivity%0Acom.xcodemaster.carenvpn.ui.PerAppProxyActivity%0Acom.xcodemaster.carenvpn.ui.ScannerActivity%0Acom.xcodemaster.carenvpn.ui.LogcatActivity%0Acom.xcodemaster.carenvpn.ui.RoutingSettingActivity%0Acom.xcodemaster.carenvpn.ui.RoutingEditActivity%0Acom.xcodemaster.carenvpn.ui.SubSettingActivity%0Acom.xcodemaster.carenvpn.ui.UserAssetActivity%0Acom.xcodemaster.carenvpn.ui.UserAssetUrlActivity%0Acom.xcodemaster.carenvpn.ui.SubEditActivity%0Acom.xcodemaster.carenvpn.ui.ScScannerActivity%0Acom.xcodemaster.carenvpn.ui.ScSwitchActivity%0Acom.xcodemaster.carenvpn.ui.UrlSchemeActivity%0Acom.xcodemaster.carenvpn.ui.AboutActivity%0Acom.xcodemaster.carenvpn.ui.TaskerActivity%0Aio.github.g00fy2.quickie.QRScannerActivity%0Acom.android.billingclient.api.ProxyBillingActivity%0Acom.android.billingclient.api.ProxyBillingActivityV2%0Acom.google.android.gms.common.api.GoogleApiActivity%0Acom.google.android.gms.ads.AdActivity%0Acom.google.android.gms.ads.OutOfContextTestingActivity%0Acom.google.android.gms.ads.NotificationHandlerActivity%0Acom.journeyapps.barcodescanner.CaptureActivity%0Acom.google.android.play.core.common.PlayCoreDialogWrapperActivity%0Acom.pairip.licensecheck.LicenseActivity%0A%0AContent%20Providers%3A%0Acom.xcodemaster.carenvpn.androidx-startup%0Acom.xcodemaster.carenvpn.cache%0Acom.xcodemaster.carenvpn.mobileadsinitprovider%0Acom.xcodemaster.carenvpn.firebaseinitprovider%0Acom.xcodemaster.carenvpn.com.pairip.licensecheck.LicenseContentProvider%0Acom.xcodemaster.carenvpn.com.pairip.licensecheck.LicenseContentProvider1%0A%0AProviders%20with%20Permissions%3A%0AProvider%3A%20androidx.startup.InitializationProvider%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0AProvider%3A%20androidx.core.content.FileProvider%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0AProvider%3A%20com.google.android.gms.ads.MobileAdsInitProvider%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0AProvider%3A%20com.google.firebase.provider.FirebaseInitProvider%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0AProvider%3A%20com.pairip.licensecheck.LicenseContentProvider%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0AProvider%3A%20com.pairip.licensecheck.LicenseContentProvider1%0A%20%20Read%20Permission%3A%20%E2%80%94%0A%20%20Write%20Permission%3A%20%E2%80%94%0A%0A&apk_hash=9336716',
  CURLOPT_HTTPHEADER => $headers,
]);
$response1 = json_decode(curl_exec($curl),true);
curl_close($curl);
//==================
foreach ($response1['load_configs'] as $config) {
    $input = decrypt_config($config['config_code'],$config['token'],$s);
    preg_match_all('/(?:^|\s)(vless:\/\/[^\s]+)/', $input, $matches);
    foreach ($matches as $config) {
        foreach ($config as $config){
            echo $config;
            
        }
    }
}
