<?php
/**
 * print_aws_configs.php
 * 
 * این کد هر ۴۵ دقیقه یک‌بار محتوای لینک را می‌گیرد
 * فقط خطوطی را چاپ می‌کند که شامل "#Aws" باشند.
 * خروجی: فقط کانفیگ‌ها (بدون هیچ توضیح اضافه)
 */

header('Content-Type: text/plain; charset=utf-8');

// لینک اصلی
$url = 'https://fitn1.ir/Api/Eagle/Eagle.php';

// مسیر فایل کش (در همان پوشه)
$cacheFile = __DIR__ . '/cache_eagle.txt';

// مدت زمان کش به ثانیه (۴۵ دقیقه)
$cacheTTL = 45 * 60;

/**
 * گرفتن داده از URL با CURL
 */
function fetch_url($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; EagleConfigFetcher/1.0)',
    ]);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

/**
 * بررسی کش و گرفتن داده جدید در صورت نیاز
 */
function get_cached_data($url, $cacheFile, $cacheTTL) {
    if (file_exists($cacheFile)) {
        $age = time() - filemtime($cacheFile);
        if ($age < $cacheTTL) {
            // داده‌ی کش معتبر است
            return file_get_contents($cacheFile);
        }
    }
    // در غیر این صورت از اینترنت بگیر و کش کن
    $data = fetch_url($url);
    if ($data && strlen($data) > 10) {
        file_put_contents($cacheFile, $data);
    }
    return $data;
}

// دریافت داده (از کش یا اینترنت)
$data = get_cached_data($url, $cacheFile, $cacheTTL);

// اگر داده وجود ندارد، خروج
if (!$data) {
    exit("خطا در دریافت داده.\n");
}

// جدا کردن خطوط و فیلتر فقط خطوط Aws
$lines = preg_split('/\r\n|\r|\n/', $data);
foreach ($lines as $line) {
    $line = trim($line);
    if ($line && stripos($line, '#aws') !== false) {
        echo $line . "\n";
    }
}