<?php
header('Content-type: text/plain');

define('CACHE_FILE', 'cache.json'); // مسیر فایل کش (فقط شامل لیست کانفیگ‌ها)
define('INDEX_FILE', 'index.txt'); // مسیر ذخیره‌ی ایندکس برای چرخش کانفیگ‌ها
define('CACHE_TIME', 10); // زمان کش به ثانیه

// تابع دریافت اطلاعات از سرور
function fetch_data() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://urls.appsongplay.com/eu13urls.txt',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $url = json_decode(curl_exec($curl), true)['backendUrls'][0] ?? '';
    curl_close($curl);

    if (!$url) {
        return [];
    }

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url . '?&package=com.vpn.euvpn',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $res = json_decode(curl_exec($curl), true);
    curl_close($curl);

    return $res['servers'] ?? [];
}

// تابع تبدیل کانفیگ JSON به VLESS یا VMESS
function jsonserver($vlessJson, $name = 'server') { 
    $decoded_data = json_decode($vlessJson, true);

    if ($decoded_data !== null && isset($decoded_data['outbounds'][0])) {
        $data = $decoded_data['outbounds'][0];

        $protocol = $data['protocol'] ?? '';
        $settings = $data['settings']['vnext'][0] ?? [];
        $streamSettings = $data['streamSettings'] ?? [];

        $uuid = $settings['users'][0]['id'] ?? '';
        $address = $settings['address'] ?? '';
        $port = $settings['port'] ?? '';
        $security = $streamSettings['security'] ?? 'none';
        $type = $streamSettings['network'] ?? '';

        $sni = "";
        $publicKey = "";
        $shortId = "";
        $fp = "";
        $spiderX = "";
        $host = "";
        $path = "";

        if ($security === "reality" && isset($streamSettings['realitySettings'])) {
            $sni = $streamSettings['realitySettings']['serverName'] ?? '';
            $publicKey = $streamSettings['realitySettings']['publicKey'] ?? '';
            $shortId = $streamSettings['realitySettings']['shortId'] ?? '';
            $fp = $streamSettings['realitySettings']['fingerprint'] ?? '';
            $spiderX = $streamSettings['realitySettings']['spiderX'] ?? '';
        } elseif ($security === "tls" && isset($streamSettings['tlsSettings'])) {
            $sni = $streamSettings['tlsSettings']['serverName'] ?? '';
        }

        if ($type === "ws" && isset($streamSettings['wsSettings'])) {
            $host = $streamSettings['wsSettings']['headers']['Host'] ?? '';
            $path = $streamSettings['wsSettings']['path'] ?? '';
        }

        if ($protocol === 'vless') {
            $params = "encryption=none&security=$security&type=$type";
            if ($sni) $params .= "&sni=$sni";
            if ($publicKey) $params .= "&pbk=$publicKey";
            if ($shortId) $params .= "&sid=$shortId";
            if ($fp) $params .= "&fp=$fp";
            if ($spiderX) $params .= "&spx=$spiderX";
            if ($host) $params .= "&host=$host";
            if ($path) $params .= "&path=$path";

            return "vless://{$uuid}@{$address}:{$port}?$params#{$name}";
        }
        elseif ($protocol === 'vmess') {
            // vmess handling if needed
            return "";
        }
    }
    return null;
}

// بررسی و بارگیری کش (فقط شامل لیست کانفیگ‌ها)
if (file_exists(CACHE_FILE) && (time() - filemtime(CACHE_FILE)) < CACHE_TIME) {
    $cached_data = json_decode(file_get_contents(CACHE_FILE), true);
} else {
    $cached_data = fetch_data();
    file_put_contents(CACHE_FILE, json_encode($cached_data));
}

// اگر کانفیگ‌ها خالی باشند، چاپ نشود
if (empty($cached_data)) {
    exit;
}

// دریافت ایندکس قبلی (در فایل جداگانه)
$index = 0;
if (file_exists(INDEX_FILE)) {
    $index = (int)file_get_contents(INDEX_FILE);
}

// محاسبه ایندکس جدید (چرخشی)
$index = ($index + 1) % count($cached_data);
file_put_contents(INDEX_FILE, $index);

// دریافت و چاپ کانفیگ بر اساس ایندکس جدید
$config = $cached_data[$index];
echo jsonserver($config['config'], $config['hostname']);