<?php
header('Content-type: text/plain');

define('CACHE_FILE', 'cache.json'); // مسیر فایل کش
define('CACHE_TIME', 10); // زمان کش به ثانیه

// تابع دریافت اطلاعات از سرور
function fetch_data() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://urls.appsongplay.com/eu13urls.txt',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $url = json_decode(curl_exec($curl), true)['backendUrls'][0] ?? '';
    curl_close($curl);

    if (!$url) {
        return [];
    }

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url . '?&package=com.vpn.euvpn',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $res = json_decode(curl_exec($curl), true);
    curl_close($curl);

    return $res['servers'] ?? [];
}

// تابع تبدیل کانفیگ JSON به VLESS یا VMESS
function jsonserver($vlessJson, $name = 'server') { 
    $decoded_data = json_decode($vlessJson, true);

    if ($decoded_data !== null && isset($decoded_data['outbounds'][0])) {
        $data = $decoded_data['outbounds'][0];

        $protocol = $data['protocol'] ?? '';
        $settings = $data['settings']['vnext'][0] ?? [];
        $streamSettings = $data['streamSettings'] ?? [];

        $uuid = $settings['users'][0]['id'] ?? '';
        $address = $settings['address'] ?? '';
        $port = $settings['port'] ?? '';
        $security = $streamSettings['security'] ?? 'none';

        $tlsSni = $streamSettings['tlsSettings']['serverName'] ?? '';
        $alpn = $streamSettings['tlsSettings']['alpn'] ?? [];
        $type = $streamSettings['network'] ?? '';

        $host = $streamSettings['wsSettings']['headers']['Host'] ?? '';
        $path = $streamSettings['wsSettings']['path'] ?? '';

        if ($protocol === 'vless') {
            $alpnStr = isset($alpn[0]) ? "&alpn={$alpn[0]}" : "";
            return "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}{$alpnStr}&host={$host}&path={$path}#{$name}";
        } elseif ($protocol === 'vmess') {
            $alpnStr = isset($alpn[0]) ? $alpn[0] : '';
            $vmess_data = [
                "add" => $address,
                "aid" => "0",
                "alpn" => $alpnStr,
                "fp" => "",
                "host" => "",
                "id" => $uuid,
                "net" => $type,
                "path" => $path,
                "port" => $port,
                "ps" => "new server",
                "scy" => "auto",
                "sni" => $tlsSni,
                "tls" => "",
                "type" => $type,
                "v" => "2"
            ];
            return 'vmess://' . base64_encode(json_encode($vmess_data, JSON_UNESCAPED_SLASHES));
        }
    }
    return null;
}

// بررسی و بارگیری کش
if (file_exists(CACHE_FILE) && (time() - filemtime(CACHE_FILE)) < CACHE_TIME) {
    $cached_data = json_decode(file_get_contents(CACHE_FILE), true);
} else {
    $cached_data = fetch_data();
    file_put_contents(CACHE_FILE, json_encode($cached_data));
}

// اگر کانفیگ‌ها خالی باشند، چاپ نشود
if (empty($cached_data)) {
    exit;
}

// چاپ همه کانفیگ‌ها به صورت پشت سر هم
foreach ($cached_data as $config) {
    $converted = jsonserver($config['config'], $config['hostname']);
    if ($converted) {
        echo $converted . "\n";
    }
}