<?php
$ip = long2ip(rand());

function jsonserver($vlessJson, $name = 'nima') {
    $decoded_data = json_decode($vlessJson);
    if ($decoded_data !== null) {
        $data = json_decode($vlessJson, true);
        $protocol = $data['outbounds'][0]['protocol'];
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id'];
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address'];
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port'];
        $security = $data['outbounds'][0]['streamSettings']['security'];
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn'];
        $type = $data['outbounds'][0]['streamSettings']['network'];
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host'];
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path'];

        if ($protocol == 'vless') {
            return "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn=" . ($alpn[0] ?? '') . ($alpn[1] ?? '') . "&host={$host}&path={$path}#{$name}\n";
        } else {
            $vmess = base64_encode(json_encode([
                "add" => $address, "aid" => "0", "alpn" => ($alpn[0] ?? '') . ($alpn[1] ?? ''),
                "fp" => "", "host" => "", "id" => $uuid, "net" => $type,
                "path" => $path, "port" => $port, "ps" => "new server", "scy" => "auto",
                "sni" => $tlsSni, "tls" => "", "type" => $type, "v" => "2"
            ]));
            return "vmess://{$vmess}\n";
        }
    } else {
        return $vlessJson . "\n";
    }
}

header('Content-type: text/plain; charset=utf-8');

// فایل‌های کش
$cacheFile = __DIR__ . '/cache_data.json';
$indexFile = __DIR__ . '/last_index.txt';
$cacheTTL = 30 * 60;

// کش‌خوانی یا ساخت جدید
if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTTL)) {
    $cachedData = json_decode(file_get_contents($cacheFile), true);
} else {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://raw.githubusercontent.com/Hamed3118/api/main/raaddomains.txt',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'User-Agent: okhttp/3.14.9', 'Connection: Keep-Alive',
            'CLIENT-IP: '.$ip, 'X-FORWARDED-FOR: '.$ip
        ],
    ]);
    $response = curl_exec($curl);
    curl_close($curl);

    $links = preg_split("/\r\n|\n|\r/", trim($response));
    $randomLink = $links[array_rand($links)];

    $results = [];
    for ($x = 0; $x < 10; $x++) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $randomLink . '/null/T-Mobile',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'User-Agent: okhttp/3.14.9', 'Connection: Keep-Alive',
                'CLIENT-IP: '.$ip, 'X-FORWARDED-FOR: '.$ip
            ],
        ]);
        $res = json_decode(curl_exec($curl), true)['data']['serverAdDTO'] ?? null;
        curl_close($curl);
        if ($res && isset($res['config'])) {
            $results[] = ['config' => $res['config'], 'location' => $res['location']];
        }
    }

    file_put_contents($cacheFile, json_encode($results, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    $cachedData = $results;
}

// فقط یک کانفیگ چاپ شود (با ترتیب گردشی)
$total = count($cachedData);
if ($total > 0) {
    $index = 0;
    if (file_exists($indexFile)) {
        $index = (int)file_get_contents($indexFile);
        $index = ($index + 1) % $total;
    }
    file_put_contents($indexFile, $index);
    $item = $cachedData[$index];
    echo jsonserver($item['config'], $item['location']);
} else {
    echo "هیچ کانفیگی موجود نیست\n";
}
?>