<?php
header('Content-Type: text/plain; charset=utf-8');

// ---------- دیکریپت data پروفایل‌ها ----------
function f($str, $str2, $str3) {
    $key    = substr(hash_hmac('sha256', $str3, "secret-key", true), 0, 32);
    $iv     = base64_decode($str2);
    $cipher = base64_decode($str);

    return openssl_decrypt(
        $cipher,
        'AES-256-CBC',
        $key,
        OPENSSL_RAW_DATA,
        $iv
    );
}

// ---------- ساخت هدر safety ----------
function safety() {
    $uuid = sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 65535),
        mt_rand(0, 65535),
        mt_rand(0, 65535),
        mt_rand(16384, 20479),
        mt_rand(32768, 49151),
        mt_rand(0, 65535),
        mt_rand(0, 65535),
        mt_rand(0, 65535)
    );

    $data = $uuid . '|' . (round(microtime(true) * 1000) + 5000);

    $suffix   = random_bytes(8); // 8 بایت رندوم
    $finalKey = hex2bin('8B7A69F8EDB5FF73') . $suffix; // 16 بایت کلید
    $iv       = hex2bin('77A7F6B7DEFDB8C369F5CB6F0908EC95');

    $cipher = openssl_encrypt(
        $data,
        'aes-128-cbc',
        $finalKey,
        OPENSSL_RAW_DATA,
        $iv
    );

    return base64_encode($cipher . $suffix);
}

// ---------- ارسال ریکوئست ----------
function send_request($url, $isPost = true, $body = null) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    if ($isPost) {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($body !== null) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        }
    }

    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'cache-control: no-cache',
        'apikey: 7bf4991622b9ed24d7f16c2320f35c0d',
        'packagename: com.exir.vpn',
        'versioncode: 15',
        'tz: Europe/Berlin',
        'locale: IR',
        'safety: ' . safety(),
        'user-agent: okhttp/4.11.0',
    ]);

    $resp = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err  = curl_error($ch);

    curl_close($ch);
    return [$resp, $info, $err];
}

// همه کانفیگ‌ها اینجا جمع می‌شن
$configLines = [];

/* =========================================================
 * 1) settings → splashConfig
 * =======================================================*/

list($settingsRaw, $settingsInfo, $settingsErr) = send_request(
    "https://proxy.nimadarkorg.workers.dev/https://exirpro.org:8443/api/v1/settings",
    true,
    '{"appVersionCode":"15","appVersionName":"1.4","deviceId":"8478e6ec3e2fa562","local":"","tz":"Europe/Paris"}'
);

if (!$settingsErr && ($settingsInfo['http_code'] ?? 0) === 200) {
    $settings = json_decode($settingsRaw, true);

    if (is_array($settings) && array_key_exists('splashConfig', $settings)) {
        $splashStr = $settings['splashConfig'];

        // اگر JSON بود، تک‌خطی‌اش می‌کنیم؛ وگرنه همون رشته
        if (is_string($splashStr) && strlen($splashStr) > 0) {
            $dec = json_decode($splashStr, true);
            if ($dec !== null) {
                $configLines[] = json_encode(
                    $dec,
                    JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
                );
            } else {
                $configLines[] = $splashStr;
            }
        }
    }
}

/* =========================================================
 * 2) profiles/fetch/all → همه configها
 * =======================================================*/

list($profRaw, $profInfo, $profErr) = send_request(
    "https://proxy.nimadarkorg.workers.dev/https://exirpro.org:8443/api/v1/profiles/fetch/all?retry=0",
    true,
    null
);

if (!$profErr && ($profInfo['http_code'] ?? 0) === 200) {
    $top = json_decode($profRaw, true);

    if (is_array($top) && isset($top['data'], $top['iv'], $top['timestamp'])) {
        $plain = f($top['data'], $top['iv'], $top['timestamp']);

        $profiles = json_decode($plain, true);
        if (is_array($profiles)) {
            foreach ($profiles as $p) {
                // اگر config وجود ندارد، رد می‌شویم
                if (!array_key_exists('config', $p)) {
                    continue;
                }

                $cfgVal = $p['config'];

                // اگر خودش آرایه/آبجکت JSON باشد
                if (is_array($cfgVal) || is_object($cfgVal)) {
                    $configLines[] = json_encode(
                        $cfgVal,
                        JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
                    );
                    continue;
                }

                // اگر رشته است:
                $cfg = (string)$cfgVal;
                $cfg = trim($cfg);
                if ($cfg === '') {
                    continue;
                }

                // اگر لینک آماده است (vless/vmess/...)
                if (preg_match('#^(vless|vmess|trojan|ss)://#i', $cfg)) {
                    $configLines[] = $cfg;
                    continue;
                }

                // اگر با { یا [ شروع می‌شود، یعنی احتمالاً JSON است
                $first = $cfg[0];
                if ($first === '{' || $first === '[') {
                    $dec = json_decode($cfg, true);
                    if ($dec !== null) {
                        $cfg = json_encode(
                            $dec,
                            JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
                        );
                    }
                    // اگر json_decode نشد، همون رشته خام باقی می‌مونه
                }

                // در نهایت هرچی هست، به‌عنوان یک خط اضافه می‌کنیم
                $configLines[] = $cfg;
            }
        }
    }
}

// ---------- چاپ نهایی: هر کانفیگ یک خط ----------
echo implode("\n", $configLines);