<?php
header('Content-type: application/json'); 
function random_device_id($length = 16) {
    $chars = '0123456789abcdef';
    $id = '';
    for ($i = 0; $i < $length; $i++) {
        $id .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $id;
}
$device_id = random_device_id();
$device_name = "Xiaomi MI " . random_int(5, 13);
$app_version = "1." . random_int(0, 9) . "." . random_int(0, 99);
$url = "https://api.fonvpn.com/v3/continue-as-guest";
$postFields = http_build_query([
    "device_id" => $device_id,
    "deviceDetails" => json_encode([
        "type" => "android",
        "name" => $device_name,
        "id" => $device_id,
        "version" => $app_version
    ])
]);
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postFields,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/x-www-form-urlencoded",
        "Connection: Keep-Alive",
        "User-Agent: okhttp/4.12.0",
    ],
]);
$token = json_decode(curl_exec($ch),true)['response']['token'];
curl_close($ch);
//=========
$url = "https://api.fonvpn.com/v3/servers-list";

$headers = [
    "Authorization: Bearer $token",
    "Content-Type: application/json",
    "Connection: Keep-Alive",
    "User-Agent: okhttp/4.12.0",
];

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers,
]);

$res = json_decode(curl_exec($ch),true);
curl_close($ch);
foreach ($res['servers'] as $res) {
$url = "https://api.fonvpn.com/v3/socks-port-timer";
$headers = [
    "Authorization: Bearer $token",
    "Content-Type: application/x-www-form-urlencoded",
    "Connection: Keep-Alive",
    "User-Agent: okhttp/4.12.0",
];

$postFields = http_build_query([
    "serverId" => $res['id']
]);

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postFields,
    CURLOPT_HTTPHEADER => $headers,
]);

$response = json_decode(curl_exec($ch),true);
echo "ss://". urlencode(base64_encode("{$response['method']}:{$response['password']}"))."@{$response['ip']}:{$response['port']}#{$res['name']}\n";
curl_close($ch);
}
    
