<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/Golden/trun.php?tedad=2";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false || empty(trim($response))) {
        return null;
    }

    return trim($response);
}

// پردازش لینک VLESS
function parseVlessLink($link) {
    if (empty($link) || strpos($link, "vless://") !== 0) {
        return null;
    }

    $link = str_replace("vless://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);
    if (count($authPart) < 2) {
        return null;
    }

    $uuid = $authPart[0];
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    return [
        'uuid' => $uuid,
        'address' => $address,
        'port' => $port,
        'params' => $params
    ];
}

// تولید JSON سالم با ساختار مشخص‌شده
function createJsonConfig($vlessData) {
    if (!$vlessData) {
        return null;
    }

    return [
        "log" => [
            "loglevel" => "warning"
        ],
        "inbounds" => [
            [
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true
                ],
                "sniffing" => [
                    "enabled" => true,
                    "destOverride" => ["http", "tls"]
                ]
            ]
        ],
        "outbounds" => [
            [
                "protocol" => "vless",
                "settings" => [
                    "vnext" => [
                        [
                            "address" => $vlessData['address'],
                            "port" => (int)$vlessData['port'],
                            "users" => [
                                [
                                    "id" => $vlessData['uuid'],
                                    "encryption" => "none"
                                ]
                            ]
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => "grpc",
                    "security" => "tls",
                    "tlsSettings" => [
                        "allowInsecure" => true,
                        "serverName" => $vlessData['params']['sni'] ?? ""
                    ],
                    "grpcSettings" => [
                        "serviceName" => ""
                    ]
                ],
                "mux" => [
                    "concurrency" => 1,
                    "enabled" => true,
                    "xudpConcurrency" => 1,
                    "xudpProxyUDP443" => "reject"
                ]
            ],
            [
                "protocol" => "freedom",
                "settings" => [
                    "fragment" => [
                        "interval" => "1-2",
                        "length" => "20-40",
                        "packets" => "tlshello"
                    ],
                    "noises" => [
                        [
                            "delay" => "10-16",
                            "packet" => "10-20",
                            "type" => "rand"
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => "tcp",
                    "sockopt" => [
                        "TcpNoDelay" => true,
                        "mark" => 255
                    ]
                ],
                "tag" => "fragment"
            ]
        ],
        "dns" => [
            "servers" => ["8.8.8.8", "8.8.4.4"]
        ],
        "routing" => [
            "domainStrategy" => "Asls"
        ]
    ];
}

// دریافت لینک و تولید JSON
$vlessLink = getDataFromUrl($sourceUrl);

if (empty($vlessLink)) {
    exit;
}

$vlessData = parseVlessLink($vlessLink);

if (empty($vlessData)) {
    exit;
}

$jsonConfig = createJsonConfig($vlessData);

if (empty($jsonConfig)) {
    exit;
}

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
