<?php
header('Content-Type: text/plain'); // نمایش به صورت متن خام

// جایگزینی کاراکترها
function replaceCharacters($inputString) {
    $original = "!@#$%&*)(_-+=0987654321ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba";
    $replacement = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890=+-_()*&%$#@!";
    $replacementArray = array();
    for ($i = 0; $i < strlen($original); $i++) {
        $replacementArray[$original[$i]] = $replacement[$i];
    }
    $outputString = '';
    for ($j = 0; $j < strlen($inputString); $j++) {
        $currentChar = $inputString[$j];
        if (array_key_exists($currentChar, $replacementArray)) {
            $outputString .= $replacementArray[$currentChar];
        } else {
            $outputString .= $currentChar;
        }
    }
    return $outputString;
}

// دیکریپت بدون تغییر کاراکترها
function decryptRaw($str) {
    $cipher = "AES-128-CBC";
    return openssl_decrypt(base64_decode($str), $cipher, 'kwusrfwnjvuhrlwh', OPENSSL_RAW_DATA, 'kwusrfwnjvuhrlwh');
}

// درخواست به API
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'http://marsoomateiranenovin.com/ClientV3/getServers',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS => 'Locale=fa&CellphoneBrand=Google&ApplicationVersionCode=250&Oprtr=Mobile+Communication+Company&InstallationSource=unknown&PackageName=com.alo.shootvpn&LocaleCountryCode=IR&Isp=Mobile+Communication+Company+of+Iran&AndroidId=36bc7ce94edc677e&CellphoneModel=Pixel&SimCardName=Android&IsIranian=true&sh=kwwqorsusrq&UserId=0&runCount=0&CountryCode=IR&IsConnected=false&',
    CURLOPT_HTTPHEADER => [
        'User-Agent: Dalvik/2.1.0 (Linux; U; Android 10; Galaxy S5 Build/QQ1D.200105.002)',
        'Connection: Keep-Alive',
        'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
    ],
]);
$response = curl_exec($curl);
curl_close($curl);

$data = json_decode($response, true);

// چاپ JSON اصلی
echo "=== RAW JSON RESPONSE ===\n";
echo json_encode($data, JSON_PRETTY_PRINT) . "\n\n";

// پردازش همه سرورها
$servers = $data['connectionRequests'] ?? [];
foreach ($servers as $index => $serverInfo) {
    $base64Str = $serverInfo['server']['ovpnFileBody'] ?? '';
    $decrypted = decryptRaw($base64Str);
    $replaced = replaceCharacters($decrypted);

    // فقط کانفیگ‌های Splash را چاپ کن
    if (stripos($replaced, "splash") !== false) {
        echo "=== SERVER #" . ($index + 1) . " (SPLASH) ===\n";
        echo $replaced . "\n\n";
    }
}
?>