<?php
header('Content-Type: application/json');

function replaceCharacters($inputString) {
    $original = "!@#$%&*)(_-+=0987654321ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba";
    $replacement = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890=+-_()*&%$#@!";
    $replacementArray = array();
    for ($i = 0; $i < strlen($original); $i++) {
        $replacementArray[$original[$i]] = $replacement[$i];
    }
    $outputString = '';
    for ($j = 0; $j < strlen($inputString); $j++) {
        $currentChar = $inputString[$j];
        if (array_key_exists($currentChar, $replacementArray)) {
            $outputString .= $replacementArray[$currentChar];
        } else {
            $outputString .= $currentChar;
        }
    }
    return $outputString;
}

function decrypt($str) {
    $cipher = "AES-128-CBC";
    $decrypted = openssl_decrypt(base64_decode($str), $cipher, 'kwusrfwnjvuhrlwh', OPENSSL_RAW_DATA, 'kwusrfwnjvuhrlwh');
    return replaceCharacters($decrypted);
}

function server() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'http://marsoomateiranenovin.com/ClientV3/getServers',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => 'Locale=fa&CellphoneBrand=Google&ApplicationVersionCode=250&Oprtr=Mobile+Communication+Company&InstallationSource=unknown&PackageName=com.alo.shootvpn&LocaleCountryCode=IR&Isp=Mobile+Communication+Company+of+Iran&AndroidId=36bc7ce94edc677e&CellphoneModel=Pixel&SimCardName=Android&IsIranian=true&sh=kwwqorsusrq&UserId=0&runCount=0&CountryCode=IR&IsConnected=false&',
        CURLOPT_HTTPHEADER => [
            'User-Agent: Dalvik/2.1.0 (Linux; U; Android 10; Galaxy S5 Build/QQ1D.200105.002)',
            'Connection: Keep-Alive',
            'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
        ],
    ]);
    $response = json_decode(curl_exec($curl), true);
    curl_close($curl);
    return decrypt($response['connectionRequests'][0]['server']['ovpnFileBody']);
}

function updateCache() {
    $servers = [];
    for ($x = 0; $x < 10; $x++) {
        $servers[] = server();
    }
    file_put_contents("cache.txt", json_encode($servers));
    file_put_contents("timestamp.txt", time());
}

function loadFromCache() {
    $servers = json_decode(file_get_contents("cache.txt"), true);
    $index = array_rand($servers); // انتخاب تصادفی برای افزایش احتمال چاپ همه
    return $servers[$index];
}

function isCacheExpired() {
    if (!file_exists("timestamp.txt")) return true;
    $lastUpdate = (int)file_get_contents("timestamp.txt");
    return (time() - $lastUpdate) > (6 * 60); // ۶۲ دقیقه
}

// بررسی کش
if (isCacheExpired() || !file_exists("cache.txt")) {
    updateCache();
}

echo loadFromCache();
?>