<?php
header('Content-type: application/json');
$cache_file = 'cache.json';
$cache_time = 61 * 60; // 61 دقیقه

function fetchConfigurations() {
    $ip = long2ip(rand());
    $uuid = generateUuid();
    $configs = [];

    for ($x = 0; $x < 10; $x++) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://hizenn.com/api/v1/Luka/get-configuration',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => '{"connected":false,"segment":"Splash"}',
            CURLOPT_HTTPHEADER => [
                'User-Agent: Hizen,105,Android(30),Genymobile,Pixel,fa,'.$uuid.',CA88342879E134C7F8BE722F23681B332CE6F70CC0999B8416D98A878B9040A3',
                'Content-Type: application/json',
                'CLIENT-IP: '.$ip,
                'X-FORWARDED-FOR: '.$ip
            ],
        ]);
        $response = json_decode(curl_exec($curl), true);
        curl_close($curl);

        if (isset($response['homeConfig']['config'])) {
            $configs[] = decode($response['homeConfig']['config']);
        }
        if (isset($response['splashConfig']['config'])) {
            $configs[] = decode($response['splashConfig']['config']);
        }
    }
    
    return $configs;
}

function decode($a3) {
    $base64String = base64_decode($a3);
    $decodedLength = strlen($base64String);
    $result = "";
    if ($decodedLength >= 1) {
        $key = "R@cC0n!Vp29Xwo0!mQkdpa*p8ceg^&NF@^sT";
        $keyLength = strlen($key);
        for ($i = 0; $i < $decodedLength; $i++) {
            $v12 = ord($base64String[$i]);
            $result .= chr(ord($key[$i % $keyLength]) ^ $v12);
        }
    }
    return $result;
}

function generateUuid() {
    return sprintf('%s-%s-%s-%s-%s',
        bin2hex(random_bytes(4)),
        bin2hex(random_bytes(2)),
        bin2hex(random_bytes(2)),
        bin2hex(random_bytes(2)),
        bin2hex(random_bytes(6))
    );
}

// بررسی کش
if (file_exists($cache_file)) {
    $cache_data = json_decode(file_get_contents($cache_file), true);
    if (time() - $cache_data['timestamp'] < $cache_time) {
        $configs = $cache_data['configs'];
    } else {
        $configs = fetchConfigurations();
        file_put_contents($cache_file, json_encode(['timestamp' => time(), 'configs' => $configs]));
    }
} else {
    $configs = fetchConfigurations();
    file_put_contents($cache_file, json_encode(['timestamp' => time(), 'configs' => $configs]));
}

// انتخاب یک کانفیگ تصادفی
if (!empty($configs)) {
    echo json_encode(json_decode($configs[array_rand($configs)]), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode(["error" => "No configuration available"], JSON_PRETTY_PRINT);
}