<?php
header('Content-type: application/json');

function httpPost($url, $data)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $headers = array(
        "Content-Type: application/json; charset=utf-8",
        "User-Agent: okhttp/4.12.0"
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

function milliseconds()
{
    $mt = explode(' ', microtime());
    return intval($mt[1] * 1E3) + intval(round($mt[0] * 1E3));
}

function gen_uuid()
{
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

function dec($data)
{
    $key = '=@xthisisakeyx@=';
    $encrypted_data = base64_decode($data);
    $encrypted = substr($encrypted_data, 16);
    $iv = substr($encrypted_data, 0, 16);
    return openssl_decrypt($encrypted, 'aes-128-cbc', $key, OPENSSL_RAW_DATA, $iv);
}

// تنظیمات کش
$cache_file = 'config_cache.json';
$cache_lifetime = 62 * 60; // 62 دقیقه

// بررسی اعتبار کش
$use_cache = file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_lifetime);

if ($use_cache) {
    // خواندن از کش
    $cached_data = file_get_contents($cache_file);
    $confs = json_decode($cached_data, true);
} else {
    // دریافت داده جدید از سرور
    $res = httpPost("https://jetonlinet.com/app.php", '{"user_id":"' . gen_uuid() . '/' . milliseconds() . '"}');
    $decoded_res = dec($res);

    if (!empty($decoded_res)) {
        $confs = json_decode($decoded_res)->add_config;
        if (!empty($confs)) {
            // تغییرات در کانفیگ
            $confs = str_replace(["6e9", "c35f"], ["9e6", "f35c"], $confs);
            file_put_contents($cache_file, json_encode($confs)); // ذخیره در کش
        }
    }
}

// انتخاب تصادفی یک کانفیگ
if (!empty($confs)) {
    $configs = explode("\n", $confs); // فرض بر این است که کانفیگ‌ها در هر خط جدا شده‌اند
    $random_config = $configs[array_rand($configs)];
    die($random_config);
} else {
    die(json_encode(["error" => "No valid config available"]));
}
?>