<?php

function fetchConfig($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function parseV2RayConfig($config) {
    $parsedUrl = parse_url($config);

    if (!isset($parsedUrl['scheme'])) {
        return json_encode(["error" => "Invalid configuration format"], JSON_PRETTY_PRINT);
    }

    $scheme = $parsedUrl['scheme'];
    $address = $parsedUrl['host'];
    $port = isset($parsedUrl['port']) ? $parsedUrl['port'] : '443';
    $user = isset($parsedUrl['user']) ? $parsedUrl['user'] : '';
    $query = isset($parsedUrl['query']) ? $parsedUrl['query'] : '';
    parse_str($query, $queryParams);
    $remarks = explode("#", $config);
    $remarks = isset($remarks[1]) ? $remarks[1] : 'V2Ray Server';

    // تنظیمات شبکه
    $network = $queryParams['type'] ?? 'tcp';
    $security = $queryParams['security'] ?? 'tls';
    $encryption = $queryParams['encryption'] ?? 'none';
    $path = $queryParams['path'] ?? '/';
    $host = $queryParams['host'] ?? '';
    $sni = $queryParams['sni'] ?? '';

    $json = [
        "dns" => [
            "hosts" => [
                "domain:googleapis.cn" => "googleapis.com"
            ],
            "servers" => [
                "1.1.1.1"
            ]
        ],
        "inbounds" => [
            [
                "listen" => "127.0.0.1",
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "enabled" => true,
                    "destOverride" => ["http", "tls"]
                ],
                "tag" => "socks"
            ]
        ],
        "log" => [
            "loglevel" => "debug"
        ],
        "outbounds" => [],
        "policy" => [
            "levels" => [
                "8" => [
                    "connIdle" => 300,
                    "downlinkOnly" => 1,
                    "handshake" => 4,
                    "uplinkOnly" => 1
                ]
            ],
            "system" => [
                "statsOutboundUplink" => true,
                "statsOutboundDownlink" => true
            ]
        ],
        "routing" => [
            "domainStrategy" => "IPIfNonMatch",
            "rules" => []
        ],
        "stats" => new stdClass()
    ];

    // تنظیمات MUX برای بهبود سرعت
    $muxSettings = [
        "enabled" => true,
        "concurrency" => 16,  
        "xudpConcurrency" => 8
    ];

    // تنظیمات TCP و فرگمنت برای کاهش تاخیر
    $tcpOptimization = [
        "network" => $network,
        "security" => $security,
        "tlsSettings" => [
            "allowInsecure" => true,
            "serverName" => $sni
        ],
        "sockopt" => [
            "tcpFastOpen" => true,
            "TcpNoDelay" => true,
            "mark" => 255
        ],
        "wsSettings" => [
            "path" => $path,
            "headers" => [
                "Host" => $host
            ]
        ],
        "fragment" => [
            "length" => [20, 40],      // طول فرگمنت
            "interval" => [1, 2],      // بازه زمانی فرگمنت
            "tlshello" => true         // فعال کردن TLS Hello Fragment
        ]
    ];

    // تنظیمات Outbound
    $outbound = [
        "protocol" => $scheme,
        "tag" => "proxy",
        "mux" => $muxSettings,
        "streamSettings" => $tcpOptimization,
        "settings" => [
            "vnext" => [
                [
                    "address" => $address,
                    "port" => (int)$port,
                    "users" => [
                        [
                            "id" => $user,
                            "encryption" => $encryption,
                            "level" => 8
                        ]
                    ]
                ]
            ]
        ]
    ];

    // اضافه کردن Outbound به JSON
    $json['outbounds'][] = $outbound;

    return json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$url = "https://iran2.fitn1.ir/jet.php";
$configData = fetchConfig($url);

echo parseV2RayConfig($configData);
?>