<?php
// مسیر فایل کش
$cacheFile = 'cachjjjbe.txt';
$cacheLifetime = 6 * 60; // 10 دقیقه به ثانیه

// تابع برای دریافت داده از API
function fetchDataFromApi($url) {
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => "User-Agent: PHP\r\n",
        ],
    ]);
    $response = file_get_contents($url, false, $context);

    if ($response === false) {
        return null;
    }

    return $response;
}

// بررسی کش
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
    // داده‌ها را از کش می‌خوانیم
    $data = file_get_contents($cacheFile);
} else {
    // لینک API
    $url = "https://round-pine-92a7.rezajafari0970.workers.dev";
    $data = fetchDataFromApi($url);

    if ($data) {
        // ذخیره داده‌ها در فایل کش
        file_put_contents($cacheFile, $data);
    } else {
        exit;
    }
}

// پردازش داده‌ها
$lines = explode("\n", trim($data)); // داده‌ها را به صورت آرایه جدا می‌کنیم

if (!empty($lines)) {
    // انتخاب یک کانفیگ به صورت تصادفی
    $randomLine = $lines[array_rand($lines)];
    echo $randomLine; // فقط کانفیگ انتخاب شده را چاپ می‌کنیم
}
?>
