<?php
header("Content-Type: application/json; charset=UTF-8");

$cache_file = 'cache.json';
$index_file = 'index.txt';
$cache_duration = 300; // مدت زمان اعتبار کش: 5 دقیقه

function decrypt($encrypted_config) {
    $decoded = base64_decode($encrypted_config);
    $decrypted = openssl_decrypt($decoded, 'AES-256-CBC', "178j74k3nj042kmn368310jj842jk5ln", OPENSSL_RAW_DATA, hex2bin('0000000000000000000000000000000'));
    return $decrypted;
}

function server($vlessJson, $name = 'server') {
    $decoded_data = json_decode($vlessJson, true);
    if ($decoded_data !== null) {
        $protocol = $decoded_data['outbounds'][1]['protocol'];
        $uuid = $decoded_data['outbounds'][1]['settings']['vnext'][0]['users'][0]['id'];
        $address = $decoded_data['outbounds'][1]['settings']['vnext'][0]['address'];
        $port = $decoded_data['outbounds'][1]['settings']['vnext'][0]['port'];
        $security = $decoded_data['outbounds'][1]['streamSettings']['security'];
        $tlsSni = $decoded_data['outbounds'][1]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $decoded_data['outbounds'][1]['streamSettings']['tlsSettings']['alpn'];
        $type = $decoded_data['outbounds'][1]['streamSettings']['network'];
        $host = $decoded_data['outbounds'][1]['streamSettings']['wsSettings']['headers']['Host'];
        $path = $decoded_data['outbounds'][1]['streamSettings']['wsSettings']['path'];
        $fingerprint = $decoded_data['outbounds'][1]['streamSettings']['tlsSettings']['fingerprint'];

        if ($protocol == 'vless') {
            return "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&fp={$fingerprint}&host={$host}&path={$path}#$name\n";
        } else {
            return 'vmess://' . base64_encode(json_encode([
                "add" => $address,
                "aid" => "0",
                "alpn" => implode(",", $alpn),
                "fp" => "",
                "host" => "",
                "id" => $uuid,
                "net" => $type,
                "path" => $path,
                "port" => $port,
                "ps" => "new server",
                "scy" => "auto",
                "sni" => $tlsSni,
                "tls" => "",
                "type" => $type,
                "v" => "2"
            ])) . "\n";
        }
    } else {
        return $vlessJson . "\n";
    }
}

function fetch_config() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://lion.irondeveloper.cloud/api/config',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'androidId=73db72dea4ff9742&versionName=1.4&packageName=com.sayeh.lion&versionCode=4&auth=ea597bde397ab0ce623a29b8813865aa',
        CURLOPT_HTTPHEADER => [
            'User-Agent: okhttp/4.12.0',
            'Accept-Encoding: gzip',
            'Content-Type: application/x-www-form-urlencoded',
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);
    return decrypt($response);
}

// بررسی زمان آخرین به‌روزرسانی کش
if (file_exists($cache_file) && (time() - filemtime($cache_file) < $cache_duration)) {
    // اگر کش تازه است، داده‌ها را از کش بخوانید
    $cache_data = file_get_contents($cache_file);
    $res = json_decode($cache_data, true);
} else {
    // اگر کش منقضی شده، داده‌ها را دوباره از سرور بگیریم
    $decrypted_response = fetch_config();
    $res = json_decode($decrypted_response, true)['Servers'];
    
    // ذخیره داده‌ها در کش
    file_put_contents($cache_file, json_encode($res, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// بررسی شاخص فعلی از فایل index.txt
if (file_exists($index_file)) {
    $current_index = (int)file_get_contents($index_file);
} else {
    $current_index = 0;
}

// اگر به انتهای لیست رسیدیم، شاخص را به ابتدا برگردانیم
if ($current_index >= count($res)) {
    $current_index = 0;
}

// نمایش کانفیگ فعلی
echo server($res[$current_index]['v2ray_config']);

// افزایش شاخص و ذخیره آن در فایل
$current_index++;
file_put_contents($index_file, $current_index);