<?php
header('Content-type: application/json');
function _getCurrentMicros(){
    return (int)(microtime(true) * 1000000);
}
function _randomInt(){
    $micros = _getCurrentMicros();
    return $micros % 9973;
}
function generateNonce(){
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $nonce = '';
    for ($i = 0; $i < 32; $i++) {
        $micros = _getCurrentMicros();
        $random = _randomInt();
        $combined = $micros + $random;
        $index = $combined % strlen($chars);
        if ($index < 0) {
            $index += strlen($chars);
        }
        $nonce .= $chars[$index];
    }
    return $nonce;
}
function get_ts(){
    $micros = (int)(microtime(true) * 1000000);
    $correction = ($micros < 0) ? 999 : 0;
    $millis = intdiv($micros - $correction, 1000);
    return $millis;
}
//===================
$curl = curl_init();

curl_setopt_array($curl, [
  CURLOPT_URL => 'https://api.metavpn.biz/v1/servers',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => [
    'User-Agent: Dart/3.8 (dart:io)',
    'Accept-Encoding: gzip',
    'content-type: application/json; charset=utf-8',
    'authorization: Bearer '.base64_encode(openssl_encrypt(json_encode(['uid'=>'userId','ts'=>get_ts(),'nonce'=>generateNonce()]),'aes-256-cbc','TOnQME*zM^`Hew@XB_^uI@f50qv=oR7H',OPENSSL_RAW_DATA,'WG6c*BeO(x^JKFWY')),
  ],
]);

$response = json_decode(curl_exec($curl),true);
curl_close($curl);
foreach ($response['data'] as $data){
    $server = openssl_decrypt(base64_decode($data['conf']),'aes-256-cbc','TOnQME*zM^`Hew@XB_^uI@f50qv=oR7H',OPENSSL_RAW_DATA,'WG6c*BeO(x^JKFWY');
    echo $server."\n";
}