<?php
define('CACHE_FILE', 'metal_cache.json');
define('INDEX_FILE', 'metal_index.txt');
define('CACHE_DURATION', 21 * 60); // 21 دقیقه به ثانیه

function fetch_data() {
    $url = "https://fitn1.ir/Api/Metal/Metal.php";
    $data = @file_get_contents($url);
    if ($data === false) {
        return [];
    }

    // تبدیل به آرایه با جداسازی بر اساس فاصله یا خط جدید
    $configs = preg_split('/\s+/', trim($data));

    // حذف کانفیگ‌هایی که عبارت #nima دارند
    $filtered = array_filter($configs, function($line) {
        return stripos($line, '#nima') === false;
    });

    // بازسازی آرایه (برای داشتن ایندکس صحیح)
    return array_values($filtered);
}

function load_cache() {
    if (!file_exists(CACHE_FILE) || (time() - filemtime(CACHE_FILE) > CACHE_DURATION)) {
        $data = fetch_data();
        file_put_contents(CACHE_FILE, json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
        return $data;
    } else {
        return json_decode(file_get_contents(CACHE_FILE), true);
    }
}

function get_next_index($count) {
    $index = 0;
    if (file_exists(INDEX_FILE)) {
        $index = (int)file_get_contents(INDEX_FILE);
    }

    $next = $index % $count;
    file_put_contents(INDEX_FILE, ($index + 1) % $count);
    return $next;
}

// --- اجرای نهایی ---
$configs = load_cache();

if (count($configs) === 0) {
    die("هیچ کانفیگی موجود نیست یا دریافت نشد.");
}

$idx = get_next_index(count($configs));
echo $configs[$idx];
?>