<?php
header('Content-type: application/json');

define('CACHE_FILE', 'config_cache.json');
define('CACHE_TIME', 3900); // 65 دقیقه (65 * 60 ثانیه)

function decrypt($input) {
    $data = base64_decode($input);
    $key = "K#90mL2&pQ5@nX7";
    $length = strlen($data);
    $output = '';
    for ($i = 0; $i < $length; $i++) {
        $v20 = ord($key[$i % 16]) ^ ord($data[$i]);
        $output .= chr($i ^ ~((32 * $v20) | ($v20 >> 3)));
    }
    return $output;
}

function fetchConfigs() {
    $configs = [];
    for ($i = 0; $i < 10; $i++) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://elderemtm.com/app/redgan/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => '{"date":1743022412715,"action":"getServer","key":"rqY\/3cG4bpqExfudWyay9BfHLRwRegeIdR1hXBJkOU3Gzqa30XOWm2WUOO27vbg0fn7sN6m4lXpFBFBVC91KTb23zjwaAw:="}',
            CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
        ]);

        $response = json_decode(decrypt(curl_exec($curl)), true);
        curl_close($curl);

        if (isset($response['data']['configs']) && is_array($response['data']['configs'])) {
            foreach ($response['data']['configs'] as $config) {
                if (isset($config['config_data'])) {
                    $configs[] = $config['config_data'];
                }
            }
        }
    }
    return $configs;
}

function cacheExists() {
    return file_exists(CACHE_FILE) && (time() - filemtime(CACHE_FILE)) < CACHE_TIME;
}

function getCachedConfigs() {
    return json_decode(file_get_contents(CACHE_FILE), true);
}

function updateCache($configs) {
    file_put_contents(CACHE_FILE, json_encode($configs));
}

if (cacheExists()) {
    $configs = getCachedConfigs();
} else {
    $configs = fetchConfigs();
    updateCache($configs);
}

if (!empty($configs)) {
    $randomConfig = $configs[array_rand($configs)];
    echo $randomConfig . "\n\n";
} else {
    echo "No configuration available.\n";
}
?>