<?php
header('Content-type: application/json');
//@nimadark045

class V2Ray
{
    private $config = [];

    public function __construct($json)
    {
        if (is_string($json)) {
            $this->config = json_decode($json, true);
        } elseif (is_array($json)) {
            $this->config = $json;
        }
 
        if (!$this->config || empty($this->config['outbounds'])) {
            throw new Exception('Invalid V2Ray JSON');
        }
    }

    /* ================= PUBLIC ================= */

    public function toLinks()
    {
        $links = [];

        foreach ($this->config['outbounds'] as $ob) {

            if (in_array($ob['protocol'], ['freedom', 'blackhole'])) {
                continue;
            }

            $tag = isset($this->config['remarks'])
                ? $this->config['remarks']
                : (isset($ob['tag']) ? $ob['tag'] : 'v2ray');

            $proto = strtolower($ob['protocol']);
            $link  = null;

            switch ($proto) {
                case 'vless':
                    $link = $this->vless($ob, $tag);
                    break;
                case 'vmess':
                    $link = $this->vmess($ob, $tag);
                    break;
                case 'trojan':
                    $link = $this->trojan($ob, $tag);
                    break;
                case 'shadowsocks':
                    $link = $this->shadowsocks($ob, $tag);
                    break;
                case 'socks':
                case 'http':
                    $link = $this->simpleProxy($ob, $tag);
                    break;
            }

            if ($link) {
                $links[] = $link;
            }
        }

        return $links;
    }

    public function first()
    {
        $links = $this->toLinks();
        return isset($links[0]) ? $links[0] : null;
    }

    /* ================= VLESS ================= */

    private function vless($ob, $tag)
    {
        $srv = $ob['settings']['vnext'][0];
        $usr = $srv['users'][0];
        $ss  = isset($ob['streamSettings']) ? $ob['streamSettings'] : [];

        $net = isset($ss['network']) ? $ss['network'] : 'tcp';
        $sec = isset($ss['security']) ? $ss['security'] : 'none';

        $q = [
            'type' => $net,
            'security' => $sec
        ];

        if ($sec === 'reality') {
            $r = $ss['realitySettings'];
            $q['pbk'] = $r['publicKey'];
            $q['fp']  = isset($r['fingerprint']) ? $r['fingerprint'] : 'chrome';
            $q['sni'] = $r['serverName'];
            $q['sid'] = $r['shortId'];
            $q['spx'] = isset($r['spiderX']) ? $r['spiderX'] : '/';
        }

        if ($sec === 'tls' || $sec === 'xtls') {
            if (!empty($ss['tlsSettings']['serverName'])) {
                $q['sni'] = $ss['tlsSettings']['serverName'];
            }
            if (!empty($ss['tlsSettings']['fingerprint'])) {
                $q['fp'] = $ss['tlsSettings']['fingerprint'];
            }
        }

        $this->networkOptions($q, $ss, $net);

        return 'vless://' . $usr['id'] . '@' . $srv['address'] . ':' . $srv['port'] .
            '?' . http_build_query($q, '', '&', PHP_QUERY_RFC3986) .
            '#' . rawurlencode($tag);
    }

    /* ================= VMESS ================= */

    private function vmess($ob, $tag)
    {
        $srv = $ob['settings']['vnext'][0];
        $usr = $srv['users'][0];
        $ss  = isset($ob['streamSettings']) ? $ob['streamSettings'] : [];

        $vm = [
            'v'   => '2',
            'ps'  => $tag,
            'add' => $srv['address'],
            'port'=> (string)$srv['port'],
            'id'  => $usr['id'],
            'aid' => isset($usr['alterId']) ? (string)$usr['alterId'] : '0',
            'net' => isset($ss['network']) ? $ss['network'] : 'tcp',
            'type'=> 'none',
            'host'=> '',
            'path'=> '',
            'tls' => isset($ss['security']) ? $ss['security'] : ''
        ];

        if ($vm['net'] === 'ws') {
            $vm['path'] = isset($ss['wsSettings']['path']) ? $ss['wsSettings']['path'] : '/';
            $vm['host'] = isset($ss['wsSettings']['headers']['Host']) ? $ss['wsSettings']['headers']['Host'] : '';
        }

        if ($vm['tls'] === 'tls' && !empty($ss['tlsSettings']['serverName'])) {
            $vm['sni'] = $ss['tlsSettings']['serverName'];
        }

        return 'vmess://' . base64_encode(json_encode($vm, JSON_UNESCAPED_SLASHES));
    }

    /* ================= TROJAN ================= */

    private function trojan($ob, $tag)
    {
        $s  = $ob['settings']['servers'][0];
        $ss = isset($ob['streamSettings']) ? $ob['streamSettings'] : [];

        $net = isset($ss['network']) ? $ss['network'] : 'tcp';

        $q = [
            'security' => 'tls',
            'type' => $net
        ];

        if (!empty($ss['tlsSettings']['serverName'])) {
            $q['sni'] = $ss['tlsSettings']['serverName'];
        }

        $this->networkOptions($q, $ss, $net);

        return 'trojan://' . $s['password'] . '@' . $s['address'] . ':' . $s['port'] .
            '?' . http_build_query($q) .
            '#' . rawurlencode($tag);
    }

    /* ================= SHADOWSOCKS ================= */

    private function shadowsocks($ob, $tag)
    {
        $s = $ob['settings']['servers'][0];
        $auth = base64_encode($s['method'] . ':' . $s['password']);
        return 'ss://' . $auth . '@' . $s['address'] . ':' . $s['port'] .
            '#' . rawurlencode($tag);
    }

    /* ================= SOCKS / HTTP ================= */

    private function simpleProxy($ob, $tag)
    {
        $s = $ob['settings']['servers'][0];
        return $ob['protocol'] . '://' . $s['address'] . ':' . $s['port'] .
            '#' . rawurlencode($tag);
    }

    /* ================= NETWORK OPTIONS ================= */

    private function networkOptions(&$q, $ss, $net)
    {
        if ($net === 'ws') {
            $q['path'] = isset($ss['wsSettings']['path']) ? $ss['wsSettings']['path'] : '/';
            $q['host'] = isset($ss['wsSettings']['headers']['Host']) ? $ss['wsSettings']['headers']['Host'] : '';
        }

        if ($net === 'grpc') {
            $q['serviceName'] = isset($ss['grpcSettings']['serviceName']) ? $ss['grpcSettings']['serviceName'] : '';
            $q['mode'] = isset($ss['grpcSettings']['multiMode']) ? $ss['grpcSettings']['multiMode'] : false;
        }

        if ($net === 'http' || $net === 'xhttp') {
            $key = $net . 'Settings';
            $q['path'] = isset($ss[$key]['path']) ? $ss[$key]['path'] : '/';
            $q['host'] = isset($ss[$key]['host']) ? $ss[$key]['host'] : '';
        }

        if ($net === 'h2') {
            $q['path'] = isset($ss['httpSettings']['path']) ? $ss['httpSettings']['path'] : '/';
            $q['host'] = isset($ss['httpSettings']['host'])
                ? implode(',', $ss['httpSettings']['host'])
                : '';
        }
    }
}
function uuid_v4(){
    $data = random_bytes(16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40);
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80);

    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}
function buildRequestJson($rq = 1, $flags = []){
    static $rqCounter = 0;
    $rqCounter++;
    $s = array_merge([
        'rooted'     => false,
        'adbOn'      => false,
        'dbgBuild'   => false, 
        'fridaArts'  => false,
        'fridaPort'  => false,
    ], $flags);

    return [
        'uid' => uuid_v4(),
        'di'  => bin2hex(random_bytes(8)),
        'as'  => 'E6AB0A50F583A377BA3DC60C3C0471E71C912997E6593EFF6380592A1677F62F',
        'ts'  => (int)(microtime(true) * 1000),
        'rq'  => $rqCounter,
        's'   => $s
    ];
}
function generateFakeIranianIP() {
    $iran_ip_ranges = [['2.144.0.0', '2.147.255.255']];
    $range = $iran_ip_ranges[array_rand($iran_ip_ranges)];
    $start = ip2long($range[0]);
    $end = ip2long($range[1]);
    $rand_ip = long2ip(mt_rand($start, $end));
    return $rand_ip;
}
function decode($a3) {
    $base64String = base64_decode($a3);
    $decodedLength = strlen($base64String);
    $result = "";
    if ($decodedLength >= 1) {
        $key = "R@cC0n!Vp29Xwo0!mQkdpa*p8ceg^&NF@^sT";
        $keyLength = strlen($key);
        for ($i = 0; $i < $decodedLength; $i++) {
            $v12 = ord($base64String[$i]);
            $result .= chr(ord($key[$i % $keyLength]) ^ $v12);
        }
    }
    return $result;
}
$ip = generateFakeIranianIP();

// ----------------------------
function encrypt_v1($plaintext,$keyBase64){
    $key = base64_decode($keyBase64);
    $iv = random_bytes(12);
    $tag = "";
    $cipher = openssl_encrypt($plaintext,"aes-256-gcm",$key,OPENSSL_RAW_DATA,$iv,$tag,"",16);
    $version = chr(1);
    $final = $version . $iv . $cipher . $tag;
    return "v1." . base64_encode($final);
}
function decryptVpnData($input, $base64Key) {
    $key = base64_decode($base64Key);
    if (!$input || strpos($input, 'v2.') !== 0) {
        return null;
    }
    $b64 = substr($input, 3);
    $b64 = strtr($b64, '_-', '/+');
    $mod = strlen($b64) % 4;
    if ($mod > 0) {
        $b64 .= str_repeat('=', 4 - $mod);
    }
    $encrypted = base64_decode($b64);
    $iv = substr($encrypted, 1, 12);
    $ciphertext = substr($encrypted, 13, -16);
    $tag = substr($encrypted, -16);
    $plaintext = openssl_decrypt($ciphertext,'aes-256-gcm',$key,OPENSSL_RAW_DATA,$iv,$tag);
    $data = json_decode($plaintext, true);
    return json_encode($data['Config']);
}
//=======
for ($i = 0; $i < 1; $i++) {
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => "https://raw.githubusercontent.com/Skilledconsultant/Shared/main/raccoon.json",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 15,
]);

$urls = json_decode(decode(json_decode(curl_exec($ch),true)['interactionPoints']),true)[0];
curl_close($ch);
//=====
$key_b64 = "WrrsYq0hvGtiD54i9CUpx6GVnTUK6VbAeMduyDFqa8o=";
$key2_b64 = "tMmS4KnBmIIgpzcR+jYYQG5JxQkazy+I4V0MJEECJkg=";
$headers = [
    "User-Agent:Rosa,153,Android(28),Xiaomi,MI 9,en",
    "Accept: */*",
    "X-Rosa-Client: ".encrypt_v1(json_encode(buildRequestJson(), JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE), $key_b64),
    "Content-Type: application/json",
];
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $urls."api/v4/Raccoon/get-configuration",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => '{"connected":false,"segment":"Splash"}',
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 15,
]); 

$response = json_decode(curl_exec($ch),true);
curl_close($ch);
print_r($response);
//$v = new V2Ray(decryptVpnData($response['splashConfig']['config'],$key2_b64));
//echo $v->first()."\n";
//====
//$v = new V2Ray(decryptVpnData($response['homeConfig']['config'],$key2_b64));
//echo $v->first()."\n";
}
?>