<?php
header('Content-type: application/json');

function fetchServerData($url, $sign, $app, $uu, $final_data) {
    $ch = curl_init($url . "?k=" . $sign . "&random=" . $uu);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "sec: " . strtoupper(sha1($sign . "$%^$%^74674%$#" . $uu . "86786$%^$%^55$%" . $final_data . "$%^$%#434#$%#4$app")),
        "Content-Type: application/x-www-form-urlencoded"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode(base64_decode(code(substr($response, 6, -7))), true);
}

function jsonserver($vlessJson) { 
    $decoded_data = json_decode($vlessJson, true); 
    if ($decoded_data !== null) {
        return $decoded_data; // بازگرداندن JSON به صورت اصلی
    } else {
        return null; // اگر JSON معتبر نبود، null برگردانید
    }
}

function code($input) {
    $res = '';
    foreach (str_split($input) as $char) {
        if (ctype_upper($char)) {
            $res .= strtolower($char);
        } elseif (ctype_lower($char)) {
            $res .= strtoupper($char);
        } else {
            $res .= $char;
        }
    }
    return $res;
}

function encrypt($data) {
    $padding = 16 - (strlen($data) % 16);
    $data .= str_repeat(chr($padding), $padding);
    return base64_encode(openssl_encrypt($data, 'AES-256-CBC', 'rewe$#o89=(pcaif', OPENSSL_RAW_DATA, 'nmb@hnddf$855h$5'));
}

function loadCache($cacheFile) {
    if (file_exists($cacheFile)) {
        $cacheData = json_decode(file_get_contents($cacheFile), true);
        if (time() - $cacheData['timestamp'] < 240) { // چک کردن اعتبار کش (کمتر از 4 دقیقه)
            return $cacheData['data'];
        }
    }
    return null;
}

function saveCache($cacheFile, $data) {
    file_put_contents($cacheFile, json_encode(['timestamp' => time(), 'data' => $data], JSON_PRETTY_PRINT));
}

// فایل کش
$cacheFile = 'cache.json';

// بررسی کش
$servers = loadCache($cacheFile);

if ($servers === null) {
    // درخواست به سرور برای دریافت داده‌های جدید
    $uu = uniqid('', true);
    $url = "https://royapps.info/api/api_roy.php";
    $sign = "C9BEA59FDDE3ECEFCDE4BC356663AE1D11EE0A4E";
    $app = 'com.vpn0.ahu';
    $history = json_encode(["cs" => 1, "as" => [], "lb" => [], "p_lb" => [], "v" => 20, "cls" => [], "s22" => $sign]);
    $hash_history = strtoupper(sha1("Bfdgfd^&FG#$DF3" . $history . "Kjh*^*yyr$%$%45g4" . $history . "$%8784443@@@%#4"));
    $data = [
        "action" => "init_firebase",
        "package_name" => $app,
        "version_code" => 20,
        "version_name" => "2.0",
        "android_id" => uniqid() . "_$app",
        "sign" => $sign,
        "sign2" => $sign,
        "sign3" => $sign,
        "sdk" => 33,
        "s_id" => $sign,
        "manufacturer" => "Damn_programming",
        "model" => "Damn_programming",
        "installer" => "com.android.vending",
        "operator" => "Damn_programming",
        "operator_country" => "ir",
        "vpn_history" => encrypt($history . "@_@" . $hash_history),
        "firebase_token" => "",
        "referrer" => "",
        "g_token" => "",
        "sec" => $uu,
        "timestamp" => rtrim(strval(time()), 0)
    ];

    $final_data = code(base64_encode(json_encode($data)));
    $servers = fetchServerData($url, $sign, $app, $uu, $final_data);
    saveCache($cacheFile, $servers); // ذخیره در کش
}

// انتخاب و چاپ ترتیبی یک JSON
session_start();
if (!isset($_SESSION['last_index'])) {
    $_SESSION['last_index'] = -1;
}

$serverList = $servers['servers'];
$nextIndex = ($_SESSION['last_index'] + 1) % count($serverList);
$_SESSION['last_index'] = $nextIndex;

echo json_encode(jsonserver($serverList[$nextIndex]['config']), JSON_PRETTY_PRINT);
?>
