<?php
header('Content-type: application/json');
function generateUniqueId() {
    $deviceBrand = ["Samsung", "OnePlus", "Xiaomi", "Huawei", "Apple"];
    $deviceModel = ["Galaxy S21", "A5010", "Mi 11", "P40", "iPhone 13"];
    $osNames = ["Android", "iOS"];
    $brand = $deviceBrand[array_rand($deviceBrand)];
    $model = $deviceModel[array_rand($deviceModel)];
    $os = $osNames[array_rand($osNames)];
    $osVersion = mt_rand(8, 14);
    $build = uniqid('build-', true);
    return sprintf(
        "%s/%s/%s:%d/%s|%s|%s|%s|%s|%s|%s|%s",
        $brand,
        $brand,
        $model,
        $osVersion,
        $build,
        mt_rand(100, 999),
        strtoupper(dechex(mt_rand(256, 4096))),
        strtolower(substr(md5(uniqid()), 0, 8)),
        "unknown",
        "msm" . mt_rand(8000, 9999),
        "true",
        "user"
    );
}
function generateDeviceModel() {
    $models = ["Galaxy S21", "A5010", "Mi 11", "P40", "iPhone 13", "Pixel 6", "Redmi Note 10", "Mate 40"];
    return $models[array_rand($models)];
}

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'https://sakokuvpn.com/api/beta/external/register',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => json_encode(["osType" => "ANDROID","uniqueId" => generateUniqueId(),"deviceModel" => generateDeviceModel(),"osVersion" => "9","login" => true],true),
  CURLOPT_HTTPHEADER => [
    'User-Agent: Dart/3.5 (dart:io)',
    'Accept-Encoding: gzip',
    'content-type: application/json; charset=utf-8',
  ],
]);

$response1 = json_decode(curl_exec($curl),true);
curl_close($curl);
foreach($response1['result']['vpnAccount']['links'] as $confing){ 
    print $confing."\n";
}