<?php

function getSakokuConfigs($url)
{
    // دریافت داده‌ها از لینک
    $response = file_get_contents($url);

    if ($response === false) {
        return ['error' => 'Failed to fetch data from URL'];
    }

    // تبدیل داده‌ها به آرایه
    $configs = explode("\n", trim($response));

    $jsonConfigs = [];
    foreach ($configs as $config) {
        if (strpos($config, 'vless://') === 0) {
            // استخراج مقادیر از کانفیگ Vless
            $parsedUrl = parse_url($config);
            parse_str($parsedUrl['query'], $queryParams);

            $jsonConfig = [
                "dns" => [
                    "hosts" => [
                        "geosite:category-ads-all" => "127.0.0.1",
                        "domain:googleapis.cn" => "googleapis.com",
                        "dns.alidns.com" => [
                            "223.5.5.5",
                            "223.6.6.6",
                            "2400:3200::1",
                            "2400:3200:baba::1"
                        ],
                        "one.one.one.one" => [
                            "1.1.1.1",
                            "1.0.0.1",
                            "2606:4700:4700::1111",
                            "2606:4700:4700::1001"
                        ]
                    ],
                    "servers" => [
                        [
                            "address" => "fakedns",
                            "domains" => [
                                "geosite:cn",
                                "domain:googleapis.cn",
                                "domain:gstatic.com",
                                "domain:alidns.com",
                                "domain:doh.pub",
                                "domain:dot.pub",
                                "domain:360.cn",
                                "domain:onedns.net"
                            ]
                        ],
                        "1.1.1.1",
                        [
                            "address" => "223.5.5.5",
                            "domains" => [
                                "domain:alidns.com",
                                "domain:doh.pub",
                                "domain:dot.pub",
                                "domain:360.cn"
                            ],
                            "expectIPs" => ["geoip:cn"],
                            "skipFallback" => true
                        ]
                    ]
                ],
                "fakedns" => [
                    [
                        "ipPool" => "198.18.0.0/15",
                        "poolSize" => 1
                    ]
                ],
                "inbounds" => [
                    [
                        "port" => 10808,
                        "protocol" => "socks",
                        "settings" => [
                            "auth" => "noauth",
                            "udp" => true,
                            "userLevel" => 8
                        ],
                        "sniffing" => [
                            "destOverride" => ["http", "tls", "fakedns"],
                            "enabled" => true,
                            "routeOnly" => true
                        ],
                        "tag" => "socks"
                    ],
                    [
                        "listen" => "127.0.0.1",
                        "port" => 10853,
                        "protocol" => "dokodemo-door",
                        "settings" => [
                            "address" => "1.1.1.1",
                            "network" => "tcp,udp",
                            "port" => 53
                        ],
                        "tag" => "dns-in"
                    ]
                ],
                "log" => [
                    "loglevel" => "warning"
                ],
                "outbounds" => [
                    [
                        "mux" => [
                            "concurrency" => -1,
                            "enabled" => false,
                            "xudpConcurrency" => 8
                        ],
                        "protocol" => "vless",
                        "settings" => [
                            "vnext" => [
                                [
                                    "address" => $parsedUrl['host'],
                                    "port" => (int) $parsedUrl['port'],
                                    "users" => [
                                        [
                                            "id" => $parsedUrl['user'],
                                            "encryption" => $queryParams['encryption'] ?? 'none',
                                            "level" => 8
                                        ]
                                    ]
                                ]
                            ]
                        ],
                        "streamSettings" => [
                            "network" => $queryParams['type'] ?? 'tcp',
                            "tcpSettings" => [
                                "header" => [
                                    "type" => $queryParams['headerType'] ?? 'http',
                                    "request" => [
                                        "headers" => [
                                            "Host" => explode(",", $queryParams['host'] ?? ''),
                                            "Connection" => ["keep-alive"],
                                            "Pragma" => "no-cache",
                                            "Accept-Encoding" => ["gzip, deflate"],
                                            "User-Agent" => [
                                                "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.6478.122 Mobile Safari/537.36"
                                            ]
                                        ],
                                        "method" => "GET",
                                        "path" => ["/"],
                                        "version" => "1.1"
                                    ]
                                ]
                            ]
                        ],
                        "tag" => "proxy"
                    ],
                    [
                        "protocol" => "freedom",
                        "settings" => [
                            "domainStrategy" => "UseIP"
                        ],
                        "tag" => "direct"
                    ],
                    [
                        "protocol" => "blackhole",
                        "settings" => [
                            "response" => [
                                "type" => "http"
                            ]
                        ],
                        "tag" => "block"
                    ]
                ],
                "policy" => [
                    "levels" => [
                        "8" => [
                            "connIdle" => 60,
                            "downlinkOnly" => 10,
                            "handshake" => 4,
                            "uplinkOnly" => 10
                        ]
                    ],
                    "system" => [
                        "statsOutboundUplink" => false,
                        "statsOutboundDownlink" => false
                    ]
                ],
                "remarks" => urldecode($parsedUrl['fragment'] ?? ''),
                "routing" => [
                    "domainStrategy" => "IPIfNonMatch",
                    "rules" => [
                        [
                            "inboundTag" => ["dns-in"],
                            "outboundTag" => "dns-out",
                            "type" => "field"
                        ],
                        [
                            "domain" => ["geosite:category-ads-all"],
                            "outboundTag" => "block",
                            "type" => "field"
                        ]
                    ]
                ],
                "stats" => new stdClass()
            ];

            $jsonConfigs[] = $jsonConfig;
        }
    }

    return $jsonConfigs;
}

// استفاده از تابع
$url = 'https://fitn1.ir/Api/Sakoku/Sakoku.php';
$result = getSakokuConfigs($url);

// نمایش خروجی
header('Content-Type: application/json');
echo json_encode($result, JSON_PRETTY_PRINT);
