<?php
// فقط یک آیتم در هر اجرا چاپ می‌شود، با کش 30 دقیقه و ترتیب چرخشی
header('Content-Type: text/plain; charset=UTF-8');

$CACHE_FILE = __DIR__ . '/cache_data.json';   // محتوای دریافتیِ پردازش‌شده
$STATE_FILE = __DIR__ . '/state.json';        // برای نگهداری ایندکس جاری
$CACHE_TTL  = 30 * 60;                        // 30 دقیقه

/* ---------- helpers: crypto ---------- */
function decrypt_str(string $key, ?string $encrypted): ?string {
    if (!$encrypted) return null;
    $parts = explode(":", $encrypted);
    if (count($parts) < 2) return null;
    $iv = base64_decode($parts[1]);
    $cipherText = base64_decode($parts[0]);
    $key = substr($key, 0, 16);
    return openssl_decrypt($cipherText, "AES-128-CBC", $key, OPENSSL_RAW_DATA, $iv);
}
function encrypt_str(string $key, string $iv, string $data): ?string {
    $cipherText = openssl_encrypt($data, "AES-128-CBC", $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($cipherText) . ":" . base64_encode($iv);
}
function buildInfo() {
    // مقدار ثابت شما را برمی‌گردانیم تا سمت سرور پذیرفته شود
    return '565QU@#DME3.5.2QU@#DME8478e6ec3e2fa562QU@#DMEMI 9:28QU@#DMEEurope/AmsterdamQU@#DME270668555QU@#DMEcom.android.vendingQU@#DMEcom.devrok.shieldifyQU@#DME5bbc4ede57aad99b9822cf8efed577bdb8efdde3fef7c1f096cc41c352f15278QU@#DME5954ed6b50e82ca708c7033e06c2bdf576021a9f6dcab49419226fc13b493373QU@#DME3ce54e34f479aed6d99631f2e03b252a919f5e4b191bdbfaeb077bf12986e11f';
}

/* ---------- helpers: extract items (خام، بدون تبدیل) ---------- */
function extract_items_preserve_order(string $text): array {
    $items = [];

    // 1) کانفیگ‌های URI (vless/vmess/…)
    $uri_pattern = '/\b(?:vless|vmess|trojan|ss|hy2|hysteria2?|tuic|socks|http|https):\/\/[^\s]+/i';
    preg_match_all($uri_pattern, $text, $m1, PREG_OFFSET_CAPTURE);
    foreach ($m1[0] as $match) {
        $items[] = ['pos' => $match[1], 'val' => $match[0]];
    }

    // 2) بلاک‌های JSON متوازن
    $len = strlen($text);
    for ($i = 0; $i < $len; $i++) {
        if ($text[$i] === '{') {
            $depth = 0; $start = $i; $j = $i;
            while ($j < $len) {
                $ch = $text[$j];
                if ($ch === '{') $depth++;
                if ($ch === '}') $depth--;
                if ($depth === 0) { // بلاک کامل شد
                    $block = substr($text, $start, $j - $start + 1);
                    $items[] = ['pos' => $start, 'val' => trim($block)];
                    $i = $j; // پرش تا انتهای بلاک
                    break;
                }
                $j++;
            }
        }
    }

    // مرتب‌سازی براساس موقعیت جهت حفظ ترتیب اصلی
    usort($items, fn($a, $b) => $a['pos'] <=> $b['pos']);

    // خروجی فقط مقادیر
    $out = [];
    foreach ($items as $it) {
        $v = trim($it['val']);
        if ($v !== '') $out[] = $v;
    }

    // اگر چیزی پیدا نشد، تلاش می‌کنیم هر خط غیرخالی را به عنوان آیتم حساب کنیم
    if (empty($out)) {
        foreach (preg_split("/\r?\n/", $text) as $line) {
            $line = trim($line);
            if ($line !== '') $out[] = $line;
        }
    }
    return array_values(array_unique($out));
}

/* ---------- cache: load or refresh ---------- */
function load_cached_items(string $CACHE_FILE, int $CACHE_TTL): ?array {
    if (is_file($CACHE_FILE)) {
        $raw = file_get_contents($CACHE_FILE);
        if ($raw !== false) {
            $obj = json_decode($raw, true);
            if ($obj && isset($obj['ts'], $obj['hash'], $obj['items'])) {
                if (time() - intval($obj['ts']) < $CACHE_TTL) {
                    return $obj;
                }
            }
        }
    }
    return null;
}
function save_cached_items(string $CACHE_FILE, array $items, string $hash): void {
    $payload = json_encode(['ts' => time(), 'hash' => $hash, 'items' => $items], JSON_UNESCAPED_UNICODE);
    @file_put_contents($CACHE_FILE, $payload, LOCK_EX);
}

/* ---------- state: round-robin index ---------- */
function load_state(string $STATE_FILE): array {
    if (is_file($STATE_FILE)) {
        $raw = file_get_contents($STATE_FILE);
        $obj = json_decode($raw, true);
        if ($obj && isset($obj['idx'], $obj['hash'])) return $obj;
    }
    return ['idx' => 0, 'hash' => ''];
}
function save_state(string $STATE_FILE, int $idx, string $hash): void {
    @file_put_contents($STATE_FILE, json_encode(['idx' => $idx, 'hash' => $hash], JSON_UNESCAPED_UNICODE), LOCK_EX);
}

/* ---------- main: fetch (with cache), pick one item, print ---------- */
$cache = load_cached_items($CACHE_FILE, $CACHE_TTL);

if (!$cache) {
    // دریافت جدید از API
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://sporting.amazingtechno.com/api/v2/connect?position=0&status=1",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Accept: application/json",
            "Accept-Language: en",
            "Api-Key: AAfLJV_mc2iLlqklP8q-zSaVXxzCM",
            "X-info: " . base64_encode(encrypt_str('h2uidO*k(KHiLH98', '4FAx7C5C3A1@32sP', buildInfo())),
            "Connection: Keep-Alive",
            "User-Agent: okhttp/3.14.9"
        ],
        CURLOPT_TIMEOUT => 20,
    ]);
    $resp = curl_exec($curl);
    curl_close($curl);

    $j = json_decode($resp, true) ?: [];
    $dec1 = isset($j['config'])  ? decrypt_str('fh87UIy_djHi7jfd', $j['config'])  : '';
    $dec2 = isset($j['config2']) ? decrypt_str('fh87UIy_djHi7jfd', $j['config2']) : '';
    // اگر دیکریپت نشد، از خام API استفاده می‌کنیم
    if ($dec1 === null && isset($j['config']))  $dec1 = $j['config'];
    if ($dec2 === null && isset($j['config2'])) $dec2 = $j['config2'];

    $all = trim($dec1 . "\n" . $dec2);
    $items = extract_items_preserve_order($all);
    $hash  = hash('sha256', $all);

    save_cached_items($CACHE_FILE, $items, $hash);
    $cache = ['items' => $items, 'hash' => $hash, 'ts' => time()];
}

$items = $cache['items'] ?? [];
$hash  = $cache['hash'] ?? '';

if (empty($items)) {
    // چیزی برای چاپ نداریم
    exit; // خروجی خالی
}

$state = load_state($STATE_FILE);
// اگر لیست عوض شده، از اول شروع کن
if (($state['hash'] ?? '') !== $hash) {
    $state['idx'] = 0;
    $state['hash'] = $hash;
}

// انتخاب یک آیتم و چاپ
$idx = $state['idx'] % count($items);
echo $items[$idx] . "\n";

// به آیتم بعدی برو و ذخیره کن
$idx = ($idx + 1) % count($items);
save_state($STATE_FILE, $idx, $hash);