<?php
// چاپ یک کانفیگ خام در هر اجرا + کش 32 دقیقه + Round-Robin
header('Content-Type: text/plain; charset=UTF-8');

$CACHE_FILE = __DIR__ . '/cache_servers.json'; // لیست کانفیگ‌ها
$STATE_FILE = __DIR__ . '/state.json';         // اندیس فعلی و هش داده
$CACHE_TTL  = 32 * 60;                          // 32 دقیقه

/* ---------- helpers from your code ---------- */
function code($input) {
    $res = '';
    foreach (str_split($input) as $char) {
        if (ctype_upper($char)) $res .= strtolower($char);
        elseif (ctype_lower($char)) $res .= strtoupper($char);
        else $res .= $char;
    }
    return $res;
}
function encrypt_hist($data) {
    $padding = 16 - (strlen($data) % 16);
    $data .= str_repeat(chr($padding), $padding);
    return base64_encode(openssl_encrypt(
        $data,
        'AES-256-CBC',
        'rewe$#o89=(pcaif',
        OPENSSL_RAW_DATA,
        'nmb@hnddf$855h$5'
    ));
}

/* ---------- fetch & decode from API ---------- */
function fetch_configs_from_api(): array {
    $uu   = uniqid('', true);
    $url  = "https://speedyapps.info/api/api_shiro.php";
    $sign = "F2097DD836A2D33A838170A01134B7EF75F303D6";
    $app  = 'com.myvpn.hamed';

    $history = json_encode(["cs"=>1,"as"=>[],"lb"=>[],"p_lb"=>[],"v"=>15,"cls"=>[],"s22"=>$sign]);
    $hash_history = strtoupper(sha1("Bfdgfd^&FG#$DF3".$history."Kjh*^*yyr$%$%45g4".$history."$%8784443@@@%#4"));

    $data = [
        "action" => "init_firebase",
        "package_name" => $app,
        "version_code" => 15,
        "version_name" => "1.5",
        "android_id" => uniqid() . "_$app",
        "sign" => $sign, "sign2" => $sign, "sign3" => $sign,
        "sdk" => 33, "s_id" => $sign,
        "manufacturer" => "Fuk", "model" => "Fuk", "installer" => "com.android.vending",
        "operator" => "Fuk", "operator_country" => "ir",
        "vpn_history" => encrypt_hist($history . "@_@" . $hash_history),
        "firebase_token" => "", "referrer" => "", "g_token" => "",
        "sec" => $uu, "timestamp" => rtrim(strval(time()), 0)
    ];

    $final_data = code(base64_encode(json_encode($data)));

    $ch = curl_init($url."?k=".$sign."&random=".$uu);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $final_data,
        CURLOPT_HTTPHEADER => [
            "sec: " . strtoupper(sha1($sign."$%^$%^74674%$#".$uu."86786$%^$%^55$%".$final_data."$%^$%#434#$%#4$app")),
            "Content-Type: application/x-www-form-urlencoded"
        ],
        CURLOPT_TIMEOUT => 20,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    if ($response === false || strlen($response) < 20) return [];

    // decode wrapper: substr → code() → base64_decode → json_decode
    $payload = base64_decode(code(substr($response, 6, -7)), true);
    if ($payload === false) return [];

    $servers = json_decode($payload, true);
    if (!is_array($servers) || !isset($servers['servers']) || !is_array($servers['servers'])) return [];

    // جمع‌آوری کانفیگ‌های خام (بدون تبدیل)
    $configs = [];
    foreach ($servers['servers'] as $item) {
        if (isset($item['config']) && is_string($item['config'])) {
            $line = trim($item['config']);
            if ($line !== '') $configs[] = $line;
        }
    }
    // حذف تکراری‌ها و یک‌دست‌سازی اندیس‌ها
    $configs = array_values(array_unique($configs));
    return $configs;
}

/* ---------- cache helpers ---------- */
function load_cache($file, $ttl) {
    if (is_file($file)) {
        $raw = file_get_contents($file);
        $obj = json_decode($raw, true);
        if ($obj && isset($obj['ts'], $obj['hash'], $obj['configs'])) {
            if (time() - intval($obj['ts']) < $ttl) return $obj;
        }
    }
    return null;
}
function save_cache($file, array $configs, string $hash) {
    $payload = ['ts'=>time(), 'hash'=>$hash, 'configs'=>$configs];
    @file_put_contents($file, json_encode($payload, JSON_UNESCAPED_UNICODE), LOCK_EX);
}

/* ---------- state (round-robin) ---------- */
function load_state($file) {
    if (is_file($file)) {
        $obj = json_decode(@file_get_contents($file), true);
        if ($obj && isset($obj['idx'], $obj['hash'])) return $obj;
    }
    return ['idx'=>0, 'hash'=>''];
}
function save_state($file, $idx, $hash) {
    @file_put_contents($file, json_encode(['idx'=>$idx,'hash'=>$hash], JSON_UNESCAPED_UNICODE), LOCK_EX);
}

/* ---------- main ---------- */
$cache = load_cache($CACHE_FILE, $CACHE_TTL);
if (!$cache) {
    $configs = fetch_configs_from_api();
    $hash = hash('sha256', implode("\n", $configs));
    save_cache($CACHE_FILE, $configs, $hash);
    $cache = ['configs'=>$configs, 'hash'=>$hash, 'ts'=>time()];
}

$configs = $cache['configs'] ?? [];
$hash    = $cache['hash'] ?? '';

if (empty($configs)) {
    // چیزی برای چاپ نداریم
    exit;
}

$state = load_state($STATE_FILE);

// اگر لیست عوض شد، از اول شروع کن
if (($state['hash'] ?? '') !== $hash) {
    $state['idx'] = 0;
    $state['hash'] = $hash;
}

$idx = $state['idx'] % count($configs);

// چاپ فقط یک کانفیگ (خام، همان رشته‌ای که سرور داده)
echo $configs[$idx] . "\n";

// ایندکس بعدی و ذخیره
$idx = ($state['idx'] + 1) % count($configs);
save_state($STATE_FILE, $idx, $hash);