<?php
header('Content-type: application/json');

// مسیر فایل کش
$cacheFile = 'cache.json';
$cacheLifetime = 3600; // 1 ساعت

// بررسی کش
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
    $jsondecode = json_decode(file_get_contents($cacheFile), true);
} else {
    // API endpoint
    $url = "https://nexthour.app/api/";
    $data = [
        'api_key' => '9ocBIvxjEHCvC8CrnSf6V9oUmLaTvP4p',
        'action' => 'getV2rayServers'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'User-Agent: okhttp/4.12.0'
    ]);
    curl_setopt($ch, CURLOPT_ENCODING, "");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        die('Error: ' . curl_error($ch));
    }

    $data = explode(':', $response);
    $json = openssl_decrypt(base64_decode($data[0]), 'aes-128-cbc', '0123456789abcdef', OPENSSL_RAW_DATA, base64_decode($data[1]));
    $jsondecode = json_decode($json, true);

    // ذخیره در کش
    file_put_contents($cacheFile, json_encode($jsondecode));
    curl_close($ch);
}

// بررسی داده‌ها
if (!isset($jsondecode['data']) || empty($jsondecode['data'])) {
    die("No configuration data available.");
}

// انتخاب تصادفی یک کانفیگ
$configCount = count($jsondecode['data']);
$randomIndex = random_int(0, $configCount - 1);
$selectedConfig = $jsondecode['data'][$randomIndex];

// انتخاب تصادفی فقط یکی از مقادیر کانفیگ
$configKeys = ['config1', 'config2', 'config3', 'config4', 'config5'];
$randomConfigKey = $configKeys[random_int(0, count($configKeys) - 1)];

// نمایش فقط یک کانفیگ تصادفی
if (isset($selectedConfig[$randomConfigKey])) {
    print $selectedConfig[$randomConfigKey] . "\n";
} else {
    die("No valid configuration found.");
}
?>
