<?php
header('Content-type: application/json');
class J
{
    // تابع رمزگشایی ID (مطابق متد a)
    public static function decryptId(string $str): string
    {
        try {
            $numericValue = intval(self::charToNumericValue($str[36]));
            // استخراج 36 کاراکتر اول
            $strSubstring = substr($str, 0, 36);

            $result = '';
            $chars = str_split($strSubstring);
            foreach ($chars as $c3) {
                if (ctype_alpha($c3)) {
                    $c4 = ctype_upper($c3) ? 'A' : 'a';
                    $offset = (ord($c3) - ord($c4) - $numericValue + 26) % 26;
                    $result .= chr($offset + ord($c4));
                } elseif (ctype_digit($c3)) {
                    $offset = (ord($c3) - ord('0') - ($numericValue + 1) + 10) % 10;
                    $result .= chr($offset + ord('0'));
                } else {
                    $result .= $c3;
                }
            }
            return $result;
        } catch (Exception $e) {
            error_log("Error decrypting ID: " . $e->getMessage());
            return $str;
        }
    }

    // معادل Character.getNumericValue()
    private static function charToNumericValue(string $char): int
    {
        if (ctype_digit($char)) {
            return intval($char);
        } elseif (ctype_alpha($char)) {
            // A یا a = 10
            return ord(strtoupper($char)) - ord('A') + 10;
        } else {
            return -1;
        }
    }

    // تابع decode (مطابق متد decode)
    public static function decode(string $str): string
    {
        try {
            $decoded = base64_decode($str);
            if ($decoded === false) {
                throw new Exception("Invalid Base64 input");
            }

            $json = json_decode($decoded, true, 512, JSON_THROW_ON_ERROR);

            if (isset($json['outbounds']) && is_array($json['outbounds'])) {
                foreach ($json['outbounds'] as &$outbound) {
                    if (isset($outbound['protocol']) && $outbound['protocol'] === 'vmess') {
                        $vnextList = &$outbound['settings']['vnext'];
                        if (is_array($vnextList)) {
                            foreach ($vnextList as &$vnext) {
                                $users = &$vnext['users'];
                                if (is_array($users)) {
                                    foreach ($users as &$user) {
                                        if (isset($user['id'])) {
                                            $id = $user['id'];
                                            if (strlen($id) == 37) {
                                                $user['id'] = self::decryptId($id);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            return json_encode($json, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

        } catch (Exception $e) {
            error_log("Error decoding or decrypting: " . $e->getMessage());
            return $str;
        }
    }
}
function cleanAppCache($str) {
    $f14275a = [
        "sSCnhGkBly", "ldKU9aRLqE", "uDottFGgHc", "5g7oKFEsuc",
        "Junk5XPHyb", "eXGZ8Rjo5a", "NTEHoAKeH9", "yEc65M3dOz",
        "GusrK7rX5F", "De6lZHT5sn", "lfs6cpYpot", "mvexiYU3bF",
        "0lUOhGbe6y", "WINMSVub83", "Uuh4LySFys", "HoluQ3SWTo",
        "NB8iSCe5a4", "c9w0gVqK42", "5nbPxXOahQ", "75nxEHFyWE",
        "keysize 256", "resolv-retry infinite", "persist-remote-ip",
        "persist-key", "persist-tun"
    ];
        if ($str !== null && $str !== '') {
            foreach ($f14275a as $replace) {
                $str = str_replace($replace, '', $str);
            }
        }
        return ($str);

}
function jsonserver($vlessJson,$name = 'dark'){ 
    $decoded_data = json_decode($vlessJson); 
    if($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security']; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 
        if($protocol == 'vless'){
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn={$alpn['0']}{$alpn['1']}&host={$host}&path={$path}#".$data['remarks']; 
            return $v2ary_vless."  \n\n";
        }else{
            $v2ary_vmess = 'vmess://'.base64_encode('{"add":"'.$address.'","aid":"0","fp":"","host":"","id":"'.$uuid.'","net":"'.$type.'","path":"'.$path.'","port":"'.$port.'","ps":"'.$data['remarks'].'","scy":"auto","sni":"'.$tlsSni.'","tls":"","type":"'.$type.'","v":"2"}');
            return $v2ary_vmess."\n";
        }
    }else{
        return $vlessJson."  \n\n"; 
    }
}







class ApiStorageHandler
{
    private  $apiKey = 'dj2K9Xp#mQ$5vN8zL3^wR7yH@cF4tB6n';
    private  $packageName;

    public function __construct(string $packageName)
    {
        $this->packageName = $packageName;
    }

    // ساخت هدرها
    public function getHeaders(): array
    {
        $headers = [];
        $timestamp = time(); // معادل System.currentTimeMillis() / 1000
        $packageName = $this->packageName;

        $headers["X-API-KEY"] = $this->apiKey;
        $headers["X-PACKAGE-NAME"] = $packageName;
        $headers["X-TIMESTAMP"] = (string)$timestamp;

        // ساخت رشته ورودی برای امضا
        $strP = $timestamp . $packageName;

        try {
            // تولید HMAC-SHA256 به صورت hex
            $hmac = hash_hmac("sha256", $strP, $this->apiKey, false);
            $signature = strtolower($hmac);
        } catch (Exception $e) {
            error_log("Error generating signature: " . $e->getMessage());
            $signature = "";
        }

        $headers["X-SIGNATURE"] = $signature;

        return $headers;
    }
    public function sendRequest(string $url): string
    {
        $headersArray = $this->getHeaders();

        $curlHeaders = [];
        foreach ($headersArray as $key => $value) {
            $curlHeaders[] = "$key: $value";
        }
        $curlHeaders[] = 'User-Agent: Dalvik/2.1.0 (Linux; U; Android 9; MI 9 Build/PQ3B.190801.12191611)';
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $curlHeaders,
        ]);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            return "cURL Error: " . $error;
        }

        return $response;
    }
}
//================
$api = new ApiStorageHandler("com.apppulse.sgip");
$url = "https://usermatrix.my.id//common-api/sglite.php";
$response = json_decode($api->sendRequest($url),true);
foreach ($response['vpn_servers'] as $value) {
    if($value['Protocol'] == 'v2ray'){
        echo jsonserver(J::decode(cleanAppCache($value['Vconfig'])));
    }
}