<?php
header('Content-Type: text/plain; charset=utf-8');

// ===== تنظیمات اصلی =====
$key_hex = '4762545d4c706e28627b6f74336a236d4031216d726d56377a30343371397765';
$api_url = 'https://sufii.org/v2speed.php';
$post_fields = [
    'app_code' => '4b4d3b629883bb09387d52f3785d959e',
    's'       => '88fecb4f508e70878682fb6a759e8981d788a0c928af77916be4f3d6e7d512da795389852213ee4700976a368ff6bde1',
    'twain'   => 'dbd9d1372d36081731c11e5b0952527be04d749691973e20b0448645aa6ab7b95adcc7b2718994f06f8f95890d739327',
    'third'   => 'fb7a0c0a4b1dcba6a17989b98f5513b9',
    'fourth'  => '1736009559440',
];

// ===== تنظیمات کش =====
$cache_file = __DIR__ . '/cache_splash.json';
$cache_ttl  = 15 * 60; // 15 دقیقه

// ===== آماده‌سازی کلید =====
$key = hex2bin($key_hex);
if ($key === false) {
    http_response_code(500);
    exit("❌ خطا: کلید رمزنگاری نامعتبر است.\n");
}

// ===== خواندن از کش =====
if (file_exists($cache_file) && (time() - filemtime($cache_file)) < $cache_ttl) {
    $raw_json = file_get_contents($cache_file);
} else {
    // ===== دریافت داده از API =====
    $ch = curl_init($api_url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $post_fields,
        CURLOPT_TIMEOUT        => 25,
    ]);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($res === false) {
        http_response_code(502);
        exit("❌ خطا در دریافت پاسخ از API: $err\n");
    }

    $bin = @hex2bin(trim($res));
    if ($bin === false) {
        http_response_code(500);
        exit("❌ پاسخ دریافتی هگز معتبر نیست.\n");
    }

    // رمزگشایی با AES-256-CBC (IV همان key)
    $raw_json = openssl_decrypt($bin, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $key);
    if ($raw_json === false) {
        http_response_code(500);
        exit("❌ خطا در رمزگشایی پاسخ.\n");
    }

    // ذخیره در کش
    file_put_contents($cache_file, $raw_json, LOCK_EX);
}

// ===== استخراج فقط بخش splash =====
$data = json_decode($raw_json, true);
if (!isset($data['splash']) || !is_array($data['splash'])) {
    exit("❌ هیچ بخش splash در پاسخ یافت نشد.\n");
}

// ===== چاپ فقط کانفیگ‌های splash =====
foreach ($data['splash'] as $item) {
    if (isset($item['config']) && is_string($item['config'])) {
        echo $item['config'], "\n";
    }
}
?>