<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/Steel/steel.php";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false || empty(trim($response))) {
        return null;
    }

    return trim($response);
}

// تشخیص و پردازش لینک کانفیگ
function parseConfigLink($link) {
    $protocols = ["trojan", "vless", "vmess", "ss"];
    
    foreach ($protocols as $protocol) {
        if (strpos($link, "$protocol://") === 0) {
            return parseGeneralLink($protocol, $link);
        }
    }
    
    return null;
}

// پردازش لینک‌ها (VLESS, TROJAN, VMESS, SS)
function parseGeneralLink($protocol, $link) {
    $link = str_replace("$protocol://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);

    if (count($authPart) < 2) {
        return null;
    }

    $auth = urldecode($authPart[0]);
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    // حذف مقدار اضافی بعد از #
    if (isset($params['sni'])) {
        $params['sni'] = explode("#", $params['sni'])[0];
    }

    return [
        'protocol' => $protocol,
        'auth' => $auth,
        'address' => $address,
        'port' => (int) $port,
        'params' => $params
    ];
}

// تولید JSON استاندارد برای تمام پروتکل‌ها
function createJsonConfig($configData) {
    if (!$configData) {
        return null;
    }

    $protocol = $configData['protocol'];
    $network = $configData['params']['type'] ?? "tcp";

    return [
        "dns" => [
            "hosts" => [
                "domain:googleapis.cn" => "googleapis.com",
                "dns.google" => ["8.8.8.8", "8.8.4.4"],
                "dns.quad9.net" => ["9.9.9.9", "149.112.112.112"]
            ],
            "servers" => ["1.1.1.1"]
        ],
        "inbounds" => [
            [
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "destOverride" => ["http", "tls"],
                    "enabled" => true,
                    "routeOnly" => true
                ],
                "tag" => "socks"
            ]
        ],
        "log" => ["loglevel" => "debug"],
        "outbounds" => [
            [
                "mux" => ["concurrency" => -1, "enabled" => true],
                "protocol" => $protocol,
                "settings" => [
                    "servers" => [
                        [
                            "address" => $configData['address'],
                            "level" => 8,
                            "port" => $configData['port'],
                            ($protocol === "trojan" ? "password" : "users") => $protocol === "trojan"
                                ? $configData['auth']
                                : [["id" => $configData['auth'], "encryption" => "none", "level" => 8]]
                        ]
                    ]
                ],
                "streamSettings" => array_merge([
                    "network" => $network,
                    "security" => "tls",
                    "tlsSettings" => [
                        "allowInsecure" => true,
                        "alpn" => explode(",", $configData['params']['alpn'] ?? "h2,http/1.1"),
                        "fingerprint" => $configData['params']['fp'] ?? "randomized",
                        "serverName" => $configData['params']['sni'] ?? "",
                        "show" => false
                    ]
                ], getNetworkSettings($network, $configData['params'])),
                "tag" => "proxy"
            ],
            ["protocol" => "freedom", "settings" => ["domainStrategy" => "UseIP"], "tag" => "direct"],
            ["protocol" => "blackhole", "settings" => ["response" => ["type" => "http"]], "tag" => "block"]
        ],
        "policy" => [
            "levels" => ["8" => ["connIdle" => 300, "downlinkOnly" => 1, "handshake" => 4, "uplinkOnly" => 1]],
            "system" => ["statsOutboundUplink" => true, "statsOutboundDownlink" => true]
        ],
        "remarks" => "💦 " . strtoupper($protocol) . " - IPv4 : " . $configData['port'],
        "routing" => [
            "domainStrategy" => "AsIs",
            "rules" => [
                ["ip" => ["1.1.1.1"], "outboundTag" => "proxy", "port" => "53", "type" => "field"],
                ["ip" => ["223.5.5.5"], "outboundTag" => "direct", "port" => "53", "type" => "field"]
            ]
        ],
        "stats" => new stdClass()
    ];
}

// دریافت تنظیمات مرتبط با هر نوع شبکه
function getNetworkSettings($network, $params) {
    switch ($network) {
        case "ws":
            return ["wsSettings" => ["path" => $params['path'] ?? "", "headers" => ["Host" => $params['host'] ?? ""]]];
        case "grpc":
            return ["grpcSettings" => ["serviceName" => $params['serviceName'] ?? ""]];
        case "http":
            return ["httpSettings" => ["host" => explode(",", $params['host'] ?? ""), "path" => $params['path'] ?? ""]];
        case "kcp":
            return ["kcpSettings" => ["header" => ["type" => $params['header'] ?? "none"]]];
        case "quic":
            return ["quicSettings" => ["security" => $params['security'] ?? "none", "key" => $params['key'] ?? ""]];
        default:
            return ["tcpSettings" => ["header" => ["type" => "none"]]];
    }
}

// دریافت لینک و پردازش
$configLink = getDataFromUrl($sourceUrl);
if (empty($configLink)) exit;

$configData = parseConfigLink($configLink);
if (empty($configData)) exit;

$jsonConfig = createJsonConfig($configData);
if (empty($jsonConfig)) exit;

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>