<?php

$cacheFile = 'cache.json';
$cacheTime = 1; // 15 دقیقه
$url = 'https://fitn1.ir/Api/Steel/steel.php';

function fetchAndCache($url, $cacheFile) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $data = curl_exec($ch);
    curl_close($ch);

    if ($data) {
        // تبدیل خروجی به آرایه با جداکننده خط جدید و حذف خطوط خالی
        $dataArray = array_filter(array_map('trim', explode("\n", trim($data))));
        file_put_contents($cacheFile, json_encode($dataArray, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }

    return $dataArray;
}

function getCachedData($cacheFile, $cacheTime, $url) {
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTime)) {
        $data = json_decode(file_get_contents($cacheFile), true);
        return is_array($data) ? $data : fetchAndCache($url, $cacheFile);
    } else {
        return fetchAndCache($url, $cacheFile);
    }
}

function getRandomConfigs($configs, $count) {
    if (!is_array($configs) || empty($configs)) {
        die(json_encode(["error" => "Config array is empty or invalid"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    
    shuffle($configs);
    return array_slice($configs, 0, $count); // انتخاب تعداد مشخصی مقدار تصادفی
}

$tedad = isset($_GET['tedad']) ? intval($_GET['tedad']) : 1;
if ($tedad < 1) $tedad = 1;

$data = getCachedData($cacheFile, $cacheTime, $url);

if ($data && is_array($data) && count($data) > 0) {
    $configs = getRandomConfigs($data, $tedad);
    header('Content-Type: text/plain');
    echo implode("\n", $configs);
} else {
    echo json_encode(["error" => "No data available"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}

?>
