<?php
//header('Content-type: application/json');

// ایجاد درخواست cURL
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api-breakk.stonemain.shop/app/?action=app_data_slice',
    CURLOPT_RETURNTRANSFER => true,
]);

// اجرای درخواست و گرفتن پاسخ
$response = curl_exec($curl);

// بررسی اینکه آیا درخواست موفقیت‌آمیز بود یا نه
if(curl_errno($curl)) {
    echo 'Error:' . curl_error($curl);
    curl_close($curl);
    exit;
}

curl_close($curl);

// دیکد کردن پاسخ به JSON
$response = json_decode($response, true);

// بررسی اینکه پاسخ معتبر است یا نه
if ($response && isset($response['result']['free_servers'])) {
    $s = $response['result']['free_servers'];
    
    // بررسی اینکه آرایه free_servers خالی نیست
    if (count($s) > 0) {
        // انتخاب تصادفی یک سرور
        $randomServer = $s[rand(0, count($s) - 1)];
        
        // بررسی اینکه کلید vpn_server_config وجود دارد یا نه
        if (isset($randomServer['vpn_server_config'])) {
            // دی‌کد کردن و رمزگشایی کانفیگ سرور
            $encryptedConfig = base64_decode($randomServer['vpn_server_config']);
            $decryptedConfig = openssl_decrypt(
                $encryptedConfig,
                'AES-256-ECB',
                hex2bin('28369594a821b6430648d5c5fa2af7518269329815b70d1fe92b8c02f8a7c19d'),
                OPENSSL_RAW_DATA
            );
            
            // حذف کاراکترهای '\n' و نمایش نتیجه
            echo str_replace('\n', '', $decryptedConfig) . "\n\n";
        } else {
            echo "vpn_server_config not found.\n";
        }
    } else {
        echo "No free servers available.\n";
    }
} else {
    echo "Invalid API response or 'free_servers' not found.\n";
}