<?php
header('Content-Type: application/json');

// فایل کش برای ذخیره داده‌ها
define('CACHE_FILE', 'cache.json');
// مدت زمان کش (40 دقیقه = 2400 ثانیه)
define('CACHE_TIME', 200);

function jsonserver($vlessJson, $name = 'nima') { 
    $decoded_data = json_decode($vlessJson); 
    if ($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security'] ?? 'none'; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 

        $realitySettings = $data['outbounds'][0]['streamSettings']['realitySettings'];
        $allowInsecure = $realitySettings['allowInsecure']; 
        $fingerprint = $realitySettings['fingerprint']; 
        $publicKey = $realitySettings['publicKey']; 
        $tlsSni = $realitySettings['serverName']; 
        $shortId = $realitySettings['shortId']; 
        $spiderX = $realitySettings['spiderX']; 

        if ($protocol == 'vless') {
            $v2ary_vless = "vless://$uuid@$address:$port?path=".urlencode($path)."&security=$security&encryption=none&host=$host&type=$type#".$data['remarks'];
            return $v2ary_vless." \n";
        } else {
            $data = base64_encode(json_encode([
                "add" => $address, "aid" => "0", "alpn" => "",
                "fp" => $fingerprint, "host" => null, "id" => $uuid,
                "net" => $type, "path" => $path, "port" => $port,
                "ps" => $data['remarks'], "scy" => "auto",
                "sni" => $tlsSni, "tls" => "reality", "type" => "http", "v" => "2"
            ], true));
            return $data." \n";
        }
    } else { 
        return $vlessJson."  \n\n";
    }
} 

function decrypt($input) {
    $decoded = base64_decode($input);
    $decryptedData = openssl_decrypt($decoded, "AES-128-CBC", hex2bin('73F848E1077101B3ED920A34685320BF'), OPENSSL_RAW_DATA, hex2bin('D8EC6EDE1DE68B613BF447A8889CEC69'));
    return $decryptedData;
}

function get_cached_data() {
    if (file_exists(CACHE_FILE)) {
        $cache = json_decode(file_get_contents(CACHE_FILE), true);
        if (time() - $cache['timestamp'] < CACHE_TIME) {
            return $cache['data'];
        }
    }
    return null;
}

function update_cache($data) {
    file_put_contents(CACHE_FILE, json_encode(['timestamp' => time(), 'data' => $data]));
}

// دریافت داده از کش یا به‌روزرسانی آن
$data = get_cached_data();
if ($data === null) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://www.gproid.website/servers/pre_tala.json',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = json_decode(curl_exec($curl), true);
    curl_close($curl);

    if (isset($response['categories'])) {
        $data = [];
        foreach ($response['categories'] as $conf) {
            foreach ($conf['configs'] as $confItem) {
                preg_match('/file:\/\/(.*?)#/', decrypt($confItem), $matches);
                $data[] = base64_decode($matches[1]);
            }
        }
        update_cache($data);
    }
}

// چاپ همه کانفیگ‌ها به صورت کلی
if (!empty($data)) {
    foreach ($data as $config) {
        echo jsonserver($config);
    }
}
?>