<?php
header('Content-Type: application/json');

// تنظیمات کش
define('CACHE_FILE', 'config_cache.json');
define('CACHE_TIME', 65 * 60); // 65 دقیقه

// تابع ذخیره داده در کش
function saveCache($data) {
    file_put_contents(CACHE_FILE, json_encode(['timestamp' => time(), 'data' => $data]));
}

// تابع بارگذاری داده از کش
function loadCache() {
    if (file_exists(CACHE_FILE)) {
        $cache = json_decode(file_get_contents(CACHE_FILE), true);
        if ($cache && (time() - $cache['timestamp']) < CACHE_TIME) {
            return $cache['data'];
        }
    }
    return null;
}

// تابع برای دریافت داده‌های JSON از API
function fetchData($url) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = curl_exec($curl);
    curl_close($curl);
    return json_decode($response, true);
}

// تابع رمزگشایی
function decrypt($input) {
    $decoded = base64_decode($input);
    $decryptedData = openssl_decrypt($decoded, "AES-128-CBC", hex2bin('73F848E1077101B3ED920A34685320BF'), OPENSSL_RAW_DATA, hex2bin('D8EC6EDE1DE68B613BF447A8889CEC69'));
    return $decryptedData;
}

// تابع استخراج کانفیگ‌ها
function extractConfigs($response) {
    $configs = [];
    foreach ($response['categories'] as $conf) {
        foreach ($conf['configs'] as $config) {
            preg_match('/file:\/\/(.*?)#/', decrypt($config), $matches);
            if (!empty($matches[1])) {
                $configs[] = base64_decode($matches[1]);
            }
        }
    }
    return $configs;
}

// تابع چاپ یک کانفیگ به صورت تصادفی
function printRandomConfig($configs) {
    if (!empty($configs)) {
        $randomIndex = array_rand($configs);
        echo $configs[$randomIndex] . "\n";
    } else {
        echo json_encode(['message' => 'No configurations available']);
    }
}

// بررسی کش
$cachedData = loadCache();
if ($cachedData) {
    printRandomConfig($cachedData);
    exit;
}

// لیست API‌ها
$urls = [
    'https://www.gproid.website//servers/tip.json',
    'https://www.gproid.website//servers/gem.json'
];

// جمع‌آوری کانفیگ‌ها
$configs = [];
foreach ($urls as $url) {
    $response = fetchData($url);
    if ($response) {
        $configs = array_merge($configs, extractConfigs($response));
    }
}

// ذخیره در کش
if (!empty($configs)) {
    saveCache($configs);
    printRandomConfig($configs);
} else {
    echo json_encode(['message' => 'Failed to fetch configurations']);
}
?>