<?php
header('Content-Type: application/json');

// --- helpers ---
function decrypt_aes_256_gcm_base64($ciphertext_b64, $hex_key){
    $ciphertext = base64_decode($ciphertext_b64);
    if ($ciphertext === false) return false;

    $ivLength = 12;   // GCM standard
    $tagLength = 16;  // 128-bit tag

    if (strlen($ciphertext) < ($ivLength + $tagLength + 1)) return false;

    $iv = substr($ciphertext, 0, $ivLength);
    $tag = substr($ciphertext, -$tagLength);
    $enc = substr($ciphertext, $ivLength, -$tagLength);

    return openssl_decrypt($enc, 'aes-256-gcm', hex2bin($hex_key), OPENSSL_RAW_DATA, $iv, $tag);
}

// 1) get list of hosts (encrypted on S3)
$ch = curl_init('https://s3.amazonaws.com/rengo01/toyo02.txt');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST  => 'GET',
    CURLOPT_HTTPHEADER     => ['User-Agent: okhttp/3.14.9','Connection: Keep-Alive'],
]);
$s3_response = curl_exec($ch);
curl_close($ch);

// decrypt host list
$hosts_json = decrypt_aes_256_gcm_base64(
    $s3_response,
    'b94e30734b411d22dd9739f8b19fe560b28799694a418354cc748813efe99eae'
);
$hosts = @json_decode($hosts_json, true);
if (!is_array($hosts) || empty($hosts)) {
    // اگر به هر دلیل لیست هاست decrypt نشد، همان خام را نشان بده
    echo $s3_response;
    exit;
}

// 2) fetch /api/v1/mobile/config from a random host (RAW)
$api = $hosts[array_rand($hosts)] . '/api/v1/mobile/config';
$ch = curl_init($api);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST  => 'GET',
    CURLOPT_HTTPHEADER     => [
        'ApiKey: Zb/Xn7faTAHeIjRiQTvbGICYdZqMRc73VHdDCk7o1WvBlnyujUG1AWEIuyevLlIB',
        'VersionCode: 117',
        'Connection: Keep-Alive',
        'User-Agent: okhttp/4.12.0',
    ],
]);
$api_raw = curl_exec($ch);
curl_close($ch);

// تلاش برای decrypt فقط برای اینکه محتوای اصلی (خامِ بعد از رمزگشایی) را ببینی.
// اگر decrypt نشد، همان پاسخ خام API برگردانده می‌شود.
$api_obj = @json_decode($api_raw, true);
if (is_array($api_obj) && isset($api_obj['data'])) {
    $payload = decrypt_aes_256_gcm_base64(
        $api_obj['data'],
        '6287e4b92e76d6b4d739b6d3cf35d2a1cfd229cf7022e698c727dda4b9ef3d9e'
    );
    if ($payload !== false && strlen($payload)) {
        // دقیقاً همان متن JSON رمزگشایی‌شده بدون هیچ تغییری
        echo $payload;
        exit;
    }
}

// اگر به هر دلیل رمزگشایی انجام نشد، خروجی خام همان پاسخ API را بده
echo $api_raw;