<?php
header('Content-type: application/json');

// مسیر فایل کش
$cacheFile = 'cache.json';
// زمان انقضای کش (۶۳ دقیقه)
$cacheTime = 63 * 60;

function jsonserver($vlessJson){ 
    $decoded_data = json_decode($vlessJson); 
    if($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security']; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 

        // تنظیمات Reality
        $realitySettings = $data['outbounds'][0]['streamSettings']['realitySettings'];
        $allowInsecure = $realitySettings['allowInsecure']; 
        $fingerprint = $realitySettings['fingerprint']; 
        $publicKey = $realitySettings['publicKey']; 
        $tlsSni = $realitySettings['serverName']; 
        $shortId = $realitySettings['shortId']; 
        $spiderX = $realitySettings['spiderX']; 

        if($protocol == 'vless'){
            $v2ary_vless = "vless://$uuid@$address:$port?security=$security&encryption=none&pbk=$publicKey&headerType=none&fp=$fingerprint&type=$type&sni=$tlsSni&sid=$shortId#".$data['remarks'];
            return $v2ary_vless." \n";
        } else {
            $data = base64_encode(json_encode([
                "add" => $address,
                "aid" => "0",
                "alpn" => "",
                "fp" => $fingerprint,
                "host" => null,
                "id" => $uuid,
                "net" => $type,
                "path" => $path,
                "port" => $port,
                "ps" => $data['remarks'],
                "scy" => "auto",
                "sni" => $tlsSni,
                "tls" => "reality",
                "type" => "http",
                "v" => "2"
            ], true));
            return $data." \n";
        }
    } else { 
        return $vlessJson."  \n\n";
    }
}

// چک کردن فایل کش
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    // خواندن از کش
    $cachedResponse = file_get_contents($cacheFile);
    $response = json_decode($cachedResponse, true);
} else {
    // فراخوانی API و ذخیره در کش
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://trianglevpn.nullexp3rror.workers.dev/',
        CURLOPT_RETURNTRANSFER => true
    ]);
    $response = json_decode(curl_exec($curl), true);
    curl_close($curl);

    if ($response) {
        file_put_contents($cacheFile, json_encode($response));
    }
}

// انتخاب یک کانفیگ به صورت تصادفی
if (!empty($response['configs'])) {
    $randomConfig = $response['configs'][array_rand($response['configs'])];
    echo jsonserver(json_encode($randomConfig, true));
} else {
    echo "هیچ کانفیگی موجود نیست.";
}

?>