<?php
header('Content-type: application/json; charset=utf-8');

$cacheFile = 'cache.json';
$cacheTime = 63 * 60; // 63 دقیقه

/** settings=[] -> {} در کل درخت */
function sanitizeSettingsArrays(&$node) {
    if (is_array($node)) {
        foreach ($node as $k => &$v) {
            if ($k === 'settings' && is_array($v) && empty($v)) {
                $v = (object)[];
            } else {
                sanitizeSettingsArrays($v);
            }
        }
        unset($v);
    }
}

/** inbound ساکس را با v2rayNG هماهنگ کن: 127.0.0.1:10808 */
function fixInboundSocksPort(&$config) {
    if (!isset($config['inbounds']) || !is_array($config['inbounds'])) return;
    foreach ($config['inbounds'] as &$inb) {
        if (isset($inb['protocol']) && strtolower($inb['protocol']) === 'socks') {
            $inb['listen'] = '127.0.0.1';
            $inb['port']   = 10808;
            if (!isset($inb['settings']) || (is_array($inb['settings']) && empty($inb['settings']))) {
                $inb['settings'] = (object)[];
            }
        }
    }
    unset($inb);
}

/** جمع‌آوری تگ‌های outbounds برای ارجاع‌ها */
function collectOutboundTags($config) {
    $tags = [];
    if (isset($config['outbounds']) && is_array($config['outbounds'])) {
        foreach ($config['outbounds'] as $ob) {
            if (isset($ob['tag'])) $tags[$ob['tag']] = true;
        }
    }
    return $tags;
}

/** حذف dialerProxy اگر تگش موجود نیست، یا اگر ?nodp=1 ست شده */
function fixDialerProxy(&$config) {
    $forceRemove = isset($_GET['nodp']) && $_GET['nodp'] == '1';
    $tags = collectOutboundTags($config);

    if (!isset($config['outbounds']) || !is_array($config['outbounds'])) return;
    foreach ($config['outbounds'] as &$ob) {
        if (isset($ob['streamSettings']) && is_array($ob['streamSettings'])) {
            $ss = &$ob['streamSettings'];
            if (isset($ss['sockopt']) && is_array($ss['sockopt']) && isset($ss['sockopt']['dialerProxy'])) {
                $dp = $ss['sockopt']['dialerProxy'];
                if ($forceRemove || !isset($tags[$dp])) {
                    unset($ss['sockopt']['dialerProxy']);
                    if (empty($ss['sockopt'])) unset($ss['sockopt']);
                }
            }
        }
    }
    unset($ob);
}

/** WS Host Fix: headers.Host -> wsSettings.host و حذف headers؛ همسان‌سازی با vnext[0].address */
function fixWebSocketHost(&$config) {
    if (!isset($config['outbounds']) || !is_array($config['outbounds'])) return;
    foreach ($config['outbounds'] as &$ob) {
        if (!isset($ob['streamSettings']) || !is_array($ob['streamSettings'])) continue;
        $ss = &$ob['streamSettings'];

        // فقط برای WS
        if (isset($ss['network']) && strtolower($ss['network']) === 'ws' &&
            isset($ss['wsSettings']) && is_array($ss['wsSettings'])) {

            $ws = &$ss['wsSettings'];

            // اگر headers.Host هست → به wsSettings.host منتقل و headers حذف
            if (isset($ws['headers']) && is_array($ws['headers'])) {
                if (isset($ws['headers']['Host']) && is_string($ws['headers']['Host'])) {
                    $hostVal = $ws['headers']['Host'];
                    $ws['host'] = $hostVal;
                }
                // هر چی داخل headers هست حذف؛ چون در XHTTP وجودش دردسرسازه
                unset($ws['headers']);
            }

            // اگر host داریم و vnext قابل دسترسه، address رو هم همسان کن
            if (isset($ws['host']) && isset($ob['settings']['vnext'][0]['address'])) {
                $ob['settings']['vnext'][0]['address'] = $ws['host'];
            }
        }
    }
    unset($ob);
}

/** حذف stats اگر آرایه باشد (با برخی بیلدها ناسازگار است) */
function fixStatsField(&$config) {
    if (isset($config['stats']) && is_array($config['stats'])) {
        unset($config['stats']);
    }
}

// --- کش/دریافت ---
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    $cachedResponse = file_get_contents($cacheFile);
    $response = json_decode($cachedResponse, true);
} else {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://trianglevpn.nullexp3rror.workers.dev/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 20,
    ]);
    $apiResponse = curl_exec($curl);
    curl_close($curl);

    $response = json_decode($apiResponse, true);
    if ($response) {
        file_put_contents($cacheFile, json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    }
}

// --- انتخاب و چاپ یک کانفیگ با اصلاحات ---
if (!empty($response) && is_array($response)) {
    // منبع
    $configs = [];
    if (isset($response['configs']) && is_array($response['configs'])) {
        $configs = $response['configs'];
    } elseif (array_is_list($response)) {
        $configs = $response;
    } elseif (isset($response['outbounds']) && isset($response['inbounds'])) {
        $picked = $response;
        sanitizeSettingsArrays($picked);
        fixInboundSocksPort($picked);
        fixWebSocketHost($picked);
        fixDialerProxy($picked);
        fixStatsField($picked);
        echo json_encode($picked, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }

    if (!empty($configs)) {
        $picked = $configs[array_rand($configs)];

        // انتخاب بر اساس ?id=
        if (isset($_GET['id'])) {
            $wantId = (string)$_GET['id'];
            foreach ($configs as $cfg) {
                if (isset($cfg['id']) && (string)$cfg['id'] === $wantId) {
                    $picked = $cfg;
                    break;
                }
            }
        }

        // اصلاحات
        sanitizeSettingsArrays($picked);
        fixInboundSocksPort($picked);
        fixWebSocketHost($picked);
        fixDialerProxy($picked);
        fixStatsField($picked);

        echo json_encode($picked, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }
}

echo json_encode(["error" => "هیچ کانفیگی موجود نیست."], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);