<?php
// فقط سرورهای "Ad" را چاپ می‌کند — تلاش می‌کند کلیدهای متداول را برای شناسایی Ad بررسی کند
$ip = long2ip(rand());

function jsonserver($vlessJson, $name = 'nima'){
    // اگر $vlessJson خودش آرایه‌/آبجکت باشد، آن را تبدیل می‌کنیم به JSON string برای سازگاری
    if (is_array($vlessJson) || is_object($vlessJson)) {
        $vlessJson = json_encode($vlessJson);
    }

    $decoded_data = json_decode($vlessJson, true);
    if ($decoded_data !== null && isset($decoded_data['outbounds'][0])) {
        $data = $decoded_data;
        $protocol = $data['outbounds'][0]['protocol'] ?? '';
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id'] ?? '';
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address'] ?? '';
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port'] ?? '';
        $security = $data['outbounds'][0]['streamSettings']['security'] ?? '';
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'] ?? '';
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn'] ?? [];
        $type = $data['outbounds'][0]['streamSettings']['network'] ?? '';
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host'] ?? '';
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path'] ?? '';

        // محافظت در برابر آریه‌های خالی alpn
        $alpnStr = '';
        if (is_array($alpn)) {
            $alpnStr = isset($alpn[0]) ? $alpn[0] : '';
            $alpnStr .= isset($alpn[1]) ? $alpn[1] : '';
        } else {
            $alpnStr = (string)$alpn;
        }

        if (strtolower($protocol) === 'vless') {
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSni}&type={$type}&alpn={$alpnStr}&host={$host}&path={$path}#".$name;
            return $v2ary_vless . "\n\n";
        } else {
            $vmessObj = [
                "add" => $address,
                "aid" => "0",
                "alpn" => $alpnStr,
                "fp" => "",
                "host" => $host,
                "id" => $uuid,
                "net" => $type,
                "path" => $path,
                "port" => $port,
                "ps" => "new server",
                "scy" => "auto",
                "sni" => $tlsSni,
                "tls" => "",
                "type" => $type,
                "v" => "2"
            ];
            return 'vmess://' . base64_encode(json_encode($vmessObj, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE)) . "\n\n";
        }
    } else {
        // اگر JSON نبود یا نامعتبر بود، فقط خام را برگردان
        return $vlessJson . "\n\n";
    }
}

header('Content-type: text/plain; charset=utf-8'); // خروجی قابل خواندن برای خطوط vless/vmess

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'https://raw.githubusercontent.com/Hamed3118/api/main/unicdomains.txt',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => [
    'User-Agent: okhttp/3.14.9',
    'Connection: Keep-Alive',
    'CLIENT-IP: '.$ip,
    'X-FORWARDED-FOR: '.$ip
  ],
  CURLOPT_TIMEOUT => 10
]);
$response = curl_exec($curl);
curl_close($curl);

if (!$response) {
    echo "خطا در دریافت لیست دامنه‌ها یا پاسخ خالی\n";
    exit;
}

$links = preg_split("/\r\n|\n|\r/", trim($response));
$links = array_values(array_filter($links)); // حذف خطوط خالی

if (count($links) === 0) {
    echo "لیست لینک‌ها خالی است.\n";
    exit;
}

$printed = 0;
$attempts = 0;
$maxPrint = 10;      // تعداد سروری که می‌خواهیم چاپ کنیم
$maxAttempts = 80;   // حداکثر تلاش برای جلوگیری از لوپ بینهایت

while ($printed < $maxPrint && $attempts < $maxAttempts) {
    $attempts++;
    $randomLink = $links[array_rand($links)];
    $curl = curl_init();
    curl_setopt_array($curl, [
      CURLOPT_URL => rtrim($randomLink, '/') . '/null/T-Mobile',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => [
        'User-Agent: okhttp/3.14.9',
        'Connection: Keep-Alive',
        'CLIENT-IP: '.$ip,
        'X-FORWARDED-FOR: '.$ip
      ],
      CURLOPT_TIMEOUT => 8
    ]);
    $raw = curl_exec($curl);
    curl_close($curl);

    if (!$raw) {
        // تلاش بعدی
        continue;
    }

    $json = json_decode($raw, true);
    if (!is_array($json)) continue;
    $responseItem = $json['data']['serverAdDTO'] ?? null;
    if (!$responseItem || !is_array($responseItem)) continue;

    // بررسی وجود کانفیگ و تشخیص "Ad" با کلیدهای متداول
    $hasConfig = !empty($responseItem['config']);
    $isAd = false;

    // بررسی‌های ممکن برای شاخص Ad — از متداول‌ترین کلیدها شروع می‌کنیم
    if (isset($responseItem['isAd'])) {
        $isAd = (bool)$responseItem['isAd'];
    } elseif (isset($responseItem['ad'])) {
        $isAd = (bool)$responseItem['ad'];
    } elseif (isset($responseItem['type'])) {
        $isAd = stripos($responseItem['type'], 'ad') !== false;
    } elseif (isset($responseItem['serverType'])) {
        $isAd = stripos($responseItem['serverType'], 'ad') !== false;
    } elseif (isset($responseItem['title'])) {
        $isAd = (stripos($responseItem['title'], 'ad') !== false) || (stripos($responseItem['title'], 'advert') !== false);
    } elseif (isset($responseItem['tags']) && is_array($responseItem['tags'])) {
        foreach ($responseItem['tags'] as $t) {
            if (stripos($t, 'ad') !== false || stripos($t, 'advert') !== false) {
                $isAd = true;
                break;
            }
        }
    }

    // فقط اگر کانفیگ وجود داشت و پرچم Ad زده شده بود، چاپ می‌کنیم
    if ($hasConfig && $isAd) {
        // اگر config خودش آرایه/آبجکت است، استفاده می‌کنیم، وگرنه رشتهٔ JSON را به jsondecode می‌دهیم
        $cfg = $responseItem['config'];
        // بعضی سرویس‌ها ممکن است config را به صورت رشتهٔ JSON یا حتی base64 بدهند.
        if (is_string($cfg)) {
            // تلاش برای decode مستقیم، اگر یک JSON واقعی است
            $maybe = json_decode($cfg, true);
            if ($maybe !== null) {
                $cfgToSend = $cfg; // رشتهٔ JSON قابل استفاده است
            } else {
                // اگر احتمال base64 محتمل باشد، تلاش برای decode base64
                $b = @base64_decode($cfg, true);
                if ($b !== false && json_decode($b) !== null) {
                    $cfgToSend = $b;
                } else {
                    // اگر هیچ‌کدام نبود، همان رشتهٔ اولیه را می‌فرستیم (jsonserver آن را مدیریت می‌کند)
                    $cfgToSend = $cfg;
                }
            }
        } else {
            // آرایه/آبجکت را به JSON رشته‌ای تبدیل می‌کنیم
            $cfgToSend = json_encode($cfg, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        }

        // نام/لوکیشن برای هشدار دادن به کاربر
        $name = $responseItem['location'] ?? ($responseItem['title'] ?? 'ad-server');
        echo jsonserver($cfgToSend, $name);
        $printed++;
    }
}

// پایان خروجی
if ($printed === 0) {
    echo "هیچ سرور Ad معتبری پیدا نشد.\n";
} else {
    echo "چاپ شد: {$printed} سرور Ad.\n";
}