<?php

$url = "http://us.usaapp-2435.com:8081/usa-1/all?package=com.hdesign.usavpn";


$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");


$headers = [
    "User-Agent: Dalvik/2.1.0 (Linux; U; Android 14; SM-S928B Build/UP1A.231005.007)",
    "Host: us.usaapp-2435.com:8081",
    "Connection: keep-alive",
    "Accept-Encoding: gzip, deflate, br"
];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);


$response = curl_exec($ch);
if (curl_errno($ch)) {
    echo "cURL error: " . curl_error($ch);
    exit;
}


$status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if ($status != 200) {
    echo "HTTP error code: " . $status;
    exit;
}
curl_close($ch);


$data = json_decode($response, true);
if ($data === null) {
    echo "Error decoding JSON response.";
    exit;
}


if (!isset($data['servers']) || !is_array($data['servers'])) {
    echo "No servers found in response.";
    exit;
}

function generateV2rayLink($server) {
    
    $configJson = $server['config'];
    $config = json_decode($configJson, true);
    if ($config === null) {
        return "Error decoding server config.";
    }
    
    
    $remark = isset($config['remarks']) ? $config['remarks'] : (isset($server['hostname']) ? $server['hostname'] : "Unknown");
    
    
    $vlessOutbound = null;
    if (isset($config['outbounds']) && is_array($config['outbounds'])) {
        foreach ($config['outbounds'] as $outbound) {
            if (isset($outbound['protocol']) && strtolower($outbound['protocol']) === "vless") {
                $vlessOutbound = $outbound;
                break;
            }
        }
    }
    
    if ($vlessOutbound === null) {
        return "No VLESS outbound found for server: " . $remark;
    }
    
    
    if (!isset($vlessOutbound['settings']['vnext'][0])) {
        return "Vnext info not found for server: " . $remark;
    }
    $vnext = $vlessOutbound['settings']['vnext'][0];
    $address = isset($vnext['address']) ? $vnext['address'] : "";
    $port = isset($vnext['port']) ? $vnext['port'] : "";
    
    if (!isset($vnext['users'][0])) {
        return "User info not found for server: " . $remark;
    }
    $user = $vnext['users'][0];
    $id = isset($user['id']) ? $user['id'] : "";
    $encryption = isset($user['encryption']) ? $user['encryption'] : "none";
    $security = isset($user['security']) ? $user['security'] : "auto";
    $flow = isset($user['flow']) ? $user['flow'] : "";
    
    
    $streamSettings = isset($vlessOutbound['streamSettings']) ? $vlessOutbound['streamSettings'] : [];
    $network = isset($streamSettings['network']) ? $streamSettings['network'] : "";
    $serviceName = "";
    if ($network === "grpc" && isset($streamSettings['grpcSettings']['serviceName'])) {
        $serviceName = $streamSettings['grpcSettings']['serviceName'];
    }
    
    
    $params = [
        "encryption"  => $encryption,
        "security"    => $security,
        "type"        => $network,
        "serviceName" => $serviceName,
        "flow"        => $flow,
        "sni"         => "",
        "fp"          => "chrome"
    ];
    $query = http_build_query($params);
    $remarkEnc = urlencode($remark);
    
    
    $link = "vless://{$id}@{$address}:{$port}?{$query}#{$remarkEnc}";
    return $link;
}


echo "<pre>";
foreach ($data['servers'] as $server) {
    $link = generateV2rayLink($server);
    echo $link . "\n";
}
echo "</pre>";
?>
