<?php
header('Content-type: application/json');

define('CACHE_FILE', 'cache.json');
define('PRINTED_FILE', 'printed.json');
define('CACHE_TIME', 600); // 10 دقیقه

function generateRandomDeviceId($length) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

function generateKey($str) {
    $digest = md5($str);
    $cArr = str_split("0123456789abcdef");
    $cArr2 = "";
    for ($i = 0; $i < 16; $i++) {
        $ss = hexdec(substr($digest, $i * 2, 2));
        $cArr2 .= $cArr[($ss & 240) >> 4];
        $cArr2 .= $cArr[$ss & 15];
    }
    return $cArr2;
}

// بررسی کش
if (file_exists(CACHE_FILE) && (time() - filemtime(CACHE_FILE)) < CACHE_TIME) {
    $addressList = json_decode(file_get_contents(CACHE_FILE), true);
} else {
    // به روزرسانی کش
    $keyapp = trim(file_get_contents('keyapp.txt'));

    $urlen = file_get_contents('https://raw.githubusercontent.com/adymob2024/gozalvpn/main/domain.txt');
    $urlde = openssl_decrypt(base64_decode($urlen), 'AES-256-CTR', '704d904a5d855a9121999830e0ef178c', OPENSSL_RAW_DATA, '5183666c72eec9e4');
    $uniquedeviceid = generateRandomDeviceId(16);

    $headers = [
        'authorization: ApiKey 65a58728-rt45-25ha-b2re-43567452890a',
        'appapikey: 4d07a501-80a6-4326-a8ab-d630520f47eb',
        'appversionname: 72.0',
        'uniquedeviceid: ' . $uniquedeviceid,
        'qwer: fukYo',
        'content-type: application/json; charset=UTF-8'
    ];

    // درخواست به API
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $urlde . '/api/v1/users/advertise',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{"uniqueDeviceId":"' . $uniquedeviceid . '"}',
        CURLOPT_HTTPHEADER => $headers,
    ]);
    $response1 = curl_exec($curl);
    curl_close($curl);

    // دریافت پروفایل‌ها
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $urlde . '/api/v5/profiles',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers
    ]);
    $response = json_decode(curl_exec($curl), true);
    curl_close($curl);

    // پردازش داده‌ها
    $servers = json_decode(openssl_decrypt(base64_decode($response['data']), 'AES-256-CTR', generateKey($uniquedeviceid . $keyapp), OPENSSL_RAW_DATA, '5183666c72eec9e4'), true);

    $addressList = [];
    foreach ($servers as $config) {
        foreach ($config['countries'] as $country) {
            foreach ($country['servers'] as $server) {
                if (isset($server['address'])) {
                    $decodedAddress = json_decode($server['address'], true);
                    if ($decodedAddress !== null) {
                        $addressList[] = $decodedAddress;
                    } else {
                        $addressList[] = $server['address'];
                    }
                }
            }
        }
    }

    // ذخیره در کش
    file_put_contents(CACHE_FILE, json_encode($addressList, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// مدیریت چاپ تصادفی
$printed = [];
if (file_exists(PRINTED_FILE)) {
    $printed = json_decode(file_get_contents(PRINTED_FILE), true);
    if (!is_array($printed)) {
        $printed = [];
    }
}

// فیلتر کردن آدرس‌هایی که قبلاً چاپ شده‌اند
$unprinted = array_values(array_diff_key($addressList, array_flip($printed)));

// در صورت خالی بودن لیست چاپ نشده، ریست کردن لیست چاپ شده
if (empty($unprinted)) {
    $printed = [];
    $unprinted = $addressList;
}

// انتخاب تصادفی یک آدرس
$randomIndex = array_rand($unprinted);
$randomAddress = $unprinted[$randomIndex];

// ذخیره آدرس چاپ شده
$printed[] = $randomIndex;
file_put_contents(PRINTED_FILE, json_encode($printed, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

// چاپ آدرس به صورت JSON
echo json_encode($randomAddress, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>