<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/V2speed/v2speed.php";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    return $response === false || empty(trim($response)) ? null : trim($response);
}

// پردازش لینک VLESS
function parseVlessLink($link) {
    if (empty($link) || strpos($link, "vless://") !== 0) {
        return null;
    }

    $link = str_replace("vless://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);
    if (count($authPart) < 2) {
        return null;
    }

    $uuid = $authPart[0];
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    return [
        'uuid' => $uuid,
        'address' => $address,
        'port' => $port,
        'params' => $params
    ];
}

// تولید JSON نهایی
function createJsonConfig($vlessData) {
    if (!$vlessData) {
        return null;
    }

    return [
        "dns" => [
            "hosts" => [
                "geosite:category-ads-all" => "127.0.0.1",
                "domain:googleapis.cn" => "googleapis.com",
                "dns.alidns.com" => ["223.5.5.5", "223.6.6.6", "2400:3200::1", "2400:3200:baba::1"],
                "one.one.one.one" => ["1.1.1.1", "1.0.0.1", "2606:4700:4700::1111", "2606:4700:4700::1001"],
                "dot.pub" => ["1.12.12.12", "120.53.53.53"],
                "dns.google" => ["8.8.8.8", "8.8.4.4", "2001:4860:4860::8888", "2001:4860:4860::8844"],
                "dns.quad9.net" => ["9.9.9.9", "149.112.112.112", "2620:fe::fe", "2620:fe::9"],
                "common.dot.dns.yandex.net" => ["77.88.8.8", "77.88.8.1", "2a02:6b8::feed:0ff", "2a02:6b8:0:1::feed:0ff"]
            ],
            "servers" => [
                [
                    "address" => "fakedns",
                    "domains" => [
                        "geosite:cn", "domain:googleapis.cn", "domain:gstatic.com", "domain:alidns.com",
                        "domain:doh.pub", "domain:dot.pub", "domain:360.cn", "domain:onedns.net", "geosite:cn"
                    ]
                ],
                "1.1.1.1",
                [
                    "address" => "1.1.1.1",
                    "domains" => ["domain:googleapis.cn", "domain:gstatic.com"]
                ],
                [
                    "address" => "223.5.5.5",
                    "domains" => ["domain:alidns.com", "domain:doh.pub", "domain:dot.pub", "domain:360.cn", "domain:onedns.net", "geosite:cn"],
                    "expectIPs" => ["geoip:cn"],
                    "skipFallback" => true
                ]
            ]
        ],
        "fakedns" => [
            ["ipPool" => "198.18.0.0/15", "poolSize" => 10000]
        ],
        "inbounds" => [
            [
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "destOverride" => ["http", "tls", "fakedns"],
                    "enabled" => true,
                    "routeOnly" => true
                ],
                "tag" => "socks"
            ],
            [
                "listen" => "127.0.0.1",
                "port" => 10853,
                "protocol" => "dokodemo-door",
                "settings" => [
                    "address" => "1.1.1.1",
                    "network" => "tcp,udp",
                    "port" => 53
                ],
                "tag" => "dns-in"
            ]
        ],
        "log" => [
            "loglevel" => "warning"
        ],
        "outbounds" => [
            [
                "mux" => [
                    "concurrency" => 16,
                    "enabled" => true,
                    "xudpConcurrency" => 8,
                    "xudpProxyUDP443" => ""
                ],
                "protocol" => "vless",
                "settings" => [
                    "vnext" => [
                        [
                            "address" => $vlessData['address'],
                            "port" => (int)$vlessData['port'],
                            "users" => [
                                [
                                    "id" => $vlessData['uuid'],
                                    "encryption" => "none",
                                    "level" => 8
                                ]
                            ]
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => "ws",
                    "security" => "tls",
                    "tlsSettings" => [
                        "allowInsecure" => true,
                        "fingerprint" => "chrome",
                        "serverName" => $vlessData['params']['sni'] ?? "",
                        "show" => false
                    ],
                    "wsSettings" => [
                        "headers" => [
                            "Host" => $vlessData['params']['host'] ?? "default.host"
                        ],
                        "path" => ""
                    ]
                ],
                "tag" => "proxy"
            ],
            [
                "protocol" => "freedom",
                "settings" => ["domainStrategy" => "UseIP"],
                "tag" => "direct"
            ],
            [
                "protocol" => "blackhole",
                "settings" => ["response" => ["type" => "http"]],
                "tag" => "block"
            ],
            [
                "protocol" => "dns",
                "tag" => "dns-out"
            ]
        ],
        "policy" => [
            "levels" => [
                "8" => [
                    "connIdle" => 300,
                    "downlinkOnly" => 1,
                    "handshake" => 4,
                    "uplinkOnly" => 1
                ]
            ],
            "system" => [
                "statsOutboundUplink" => true,
                "statsOutboundDownlink" => true
            ]
        ],
        "remarks" => $vlessData['params']['remark'] ?? "SW94042",
        "routing" => [
            "domainStrategy" => "IPIfNonMatch",
            "rules" => [
                [
                    "inboundTag" => ["dns-in"],
                    "outboundTag" => "dns-out",
                    "type" => "field"
                ],
                [
                    "ip" => ["1.1.1.1"],
                    "outboundTag" => "proxy",
                    "port" => "53",
                    "type" => "field"
                ]
            ]
        ],
        "stats" => new stdClass()
    ];
}

// اجرای کد
$vlessLink = getDataFromUrl($sourceUrl);
if (empty($vlessLink)) exit;

$vlessData = parseVlessLink($vlessLink);
if (empty($vlessData)) exit;

$jsonConfig = createJsonConfig($vlessData);
if (empty($jsonConfig)) exit;

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
