<?php
// تنظیمات فایل کش
$cacheFile = 'config.txt';
$cacheTime = 62 * 60;  // 62 دقیقه به ثانیه

// بررسی زمان آخرین آپدیت
if (file_exists($cacheFile)) {
    $lastUpdate = filemtime($cacheFile);
    $currentTime = time();

    // اگر کمتر از 62 دقیقه از آخرین آپدیت گذشته باشد، از فایل کش استفاده می‌کنیم
    if (($currentTime - $lastUpdate) < $cacheTime) {
        // خواندن داده از فایل کش
        $decodedContent = file_get_contents($cacheFile);
        $configs = explode("\n", $decodedContent);

        // انتخاب تصادفی یک کانفیگ از بین همه کانفیگ‌ها
        $randomConfig = $configs[array_rand($configs)];

        echo $randomConfig . "\n";
        exit;
    }
}

// لینک اول ثابت
$firstUrl = "https://fitn1.ir/Api/V7/V7.php";

// دریافت خروجی لینک اول که آدرس لینک دوم را دارد
$secondUrl = file_get_contents($firstUrl);
if ($secondUrl === false) {
    die("خطا در بارگذاری لینک اول.");
}

// حذف فاصله‌ها و کاراکترهای اضافی
$secondUrl = trim($secondUrl);

// بررسی اینکه لینک دوم دریافت شده است یا خیر
if (empty($secondUrl)) {
    die("لینک دوم در دسترس نیست.");
}

// استفاده از CURL برای دریافت محتوای لینک دوم
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $secondUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);  // دنبال کردن ریدایرکت‌ها
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);  // غیرفعال کردن تایید گواهینامه SSL در صورت نیاز

$configContent = curl_exec($ch);
curl_close($ch);

// بررسی موفقیت در دریافت محتویات
if ($configContent === false) {
    die("خطا در بارگذاری لینک دوم.");
}

// رمزگشایی محتوا
$decodedContent = base64_decode($configContent);

// ذخیره محتوای رمزگشایی‌شده در فایل
file_put_contents($cacheFile, $decodedContent);

// تقسیم کانفیگ‌ها به آرایه‌ها
$configs = explode("\n", $decodedContent);

// انتخاب تصادفی یک کانفیگ از بین همه کانفیگ‌ها
$randomConfig = $configs[array_rand($configs)];

// نمایش کانفیگ انتخاب‌شده
echo $randomConfig . "\n";
?>
