<?php
header('Content-type: application/json');
$ip = long2ip(rand());
function signedIntsToBytes(array $ints): string {
    $s = "";
    foreach ($ints as $v) {
        $s .= chr($v & 0xFF);
    }
    return $s;
}

function clampCurve25519Scalar($scalar32){
    $b = array_values(unpack("C*", $scalar32));
    $b[1] = $b[1] & 0xF8;
    $bytes = $scalar32;
    $arr = array_map('ord', str_split($bytes));
    $arr[0] = $arr[0] & 248;
    $arr[31] = ($arr[31] & 127) | 64;
    $out = "";
    foreach ($arr as $x) $out .= chr($x);
    return $out;
}
function hkdf_sha256_expand($prk,$info,$length){
    $okm = "";
    $t = "";
    $counter = 1;
    while (strlen($okm) < $length) {
        $t = hash_hmac('sha256', $t . $info . chr($counter), $prk, true);
        $okm .= $t;
        $counter++;
        if ($counter > 255) throw new \RuntimeException("HKDF expand counter overflow");
    }
    return substr($okm, 0, $length);
}

function derive_aes_key_from_curve25519(array $private_signed_ints, string $public_base64): array {
    $priv = signedIntsToBytes($private_signed_ints);
    if (strlen($priv) !== 32) {
        $priv = str_pad(substr($priv, 0, 32), 32, "\0");
    }
    $clamped = clampCurve25519Scalar($priv);
    $pub = base64_decode($public_base64, true);
    $shared = sodium_crypto_scalarmult($clamped, $pub); // 32 bytes
    $salt = "ECDH key";
    $prk = hash_hmac('sha256', $shared, $salt, true);
    $resles = hkdf_sha256_expand($prk, "", 32);
    return ['key'=>$resles];
}
$private = [7,-92,-127,101,-79,-18,120,25,-29,-83,-7,84,69,30,83,118,-86,8,-5,-16,-112,-42,-18,-67,-7,70,-34,31,-102,-42,-100,-88];
//===============
$url = "https://api.antiv.xyz/servers/public/936regthrjppprrr";
$headers = [
    "token: 1eafd320-e21f-4979-847c-28d8b082aa68",
    "authorization: Bearer null",
    "type: official",
    "deactiveserver: true",
    "checkapp: TjVQu9YXlSgTCyWbGmXWKs4RAwwIFOYpXEVCIhp56zbIIgWP3bYPMNPy756jPcou",
    "gtoken: null",
    "check-time: wIJvBTa8jPi2tgwTdJuvwhGMfJb3y06P9nyeHozZng6++QPNHRCWIBfL7DKpFJG7bA1osjPJFIXv6mXjHxYxRw==",
    "content-type: application/json; charset=UTF-8",
    "user-agent: okhttp/5.3.0",
    "accept: */*",
    'CLIENT-IP: '.$ip,
    'X-FORWARDED-FOR: '.$ip
];

$data = [
    "isp" => "WIFI|Mobile Communication Company of Iran PLC|Mcci",
    "ip" => "95.64.61.36",
    "type" => "official",
    "current_version" => 7000827,
    "server_number" => "8478e6ec3e2fa562",
    "connected" => true,
    "connect_state" => "oAT8mM20gxvM/+klo7yPuQLCdg6nd53J8dG3esn4w0Q=",
    "server_pub" => "Ha+FBUSo9Cu/R3ByRXD+CxHI5ccDEyDVyYwVfUVeR3s=",
    "m" => "en",
];

$ch = curl_init();

curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_ENCODING => "", // equal to --compressed
]);

$response = json_decode(curl_exec($ch),true);
curl_close($ch);
foreach ($response['result']['gghhzzss']['vvff'] as $b){
    $key = derive_aes_key_from_curve25519($private, $b['server_pub'])['key'];
$plaintext = openssl_decrypt(base64_decode($b['ciphertext']), 'aes-256-gcm',$key, OPENSSL_RAW_DATA, base64_decode($b['iv']), base64_decode($b['tag']));
echo $plaintext."\n";
}











